/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;

public class APIFactory {
    private Map<File, API> apis = new HashMap<File, API>();
    private Map<String, HttpListenerConfig> domainHttpListenerConfigs = new HashMap<String, HttpListenerConfig>();

    public APIFactory(Map<String, HttpListenerConfig> domainHttpListenerConfigs) {
        this.domainHttpListenerConfigs.putAll(domainHttpListenerConfigs);
    }

    public APIFactory() {
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(ramlFile, xmlFile, baseUri, path, config, null, true);
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String path, APIKitConfig config, HttpListenerConfig httpListenerConfig) {
        return this.createAPIBinding(ramlFile, xmlFile, null, path, config, httpListenerConfig, false);
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config, HttpListenerConfig httpListenerConfig, Boolean useInboundEndpoint) {
        Validate.notNull((Object)ramlFile);
        if (this.apis.containsKey(ramlFile)) {
            API api = this.apis.get(ramlFile);
            if (api.getXmlFile() == null && xmlFile != null) {
                api.setXmlFile(xmlFile);
            }
            return api;
        }
        API api = new API(ramlFile, xmlFile, baseUri, path, config);
        api.setUseInboundEndpoint(useInboundEndpoint);
        if (!useInboundEndpoint.booleanValue()) {
            if (httpListenerConfig == null) {
                if (this.domainHttpListenerConfigs.size() > 0) {
                    api.setHttpListenerConfig(this.domainHttpListenerConfigs.values().iterator().next());
                } else {
                    api.setDefaultHttpListenerConfig();
                }
            } else {
                api.setHttpListenerConfig(httpListenerConfig);
            }
        }
        api.setConfig(config);
        this.apis.put(ramlFile, api);
        return api;
    }

    public Map<String, HttpListenerConfig> getDomainHttpListenerConfigs() {
        return this.domainHttpListenerConfigs;
    }
}

