/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.apache.commons.lang.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class ConsoleFlowScope
implements Scope {
    private final Element consoleFlow = new Element("flow", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());

    public ConsoleFlowScope(Element mule, API api, String configRef, String httpListenerConfigRef) {
        this.consoleFlow.setAttribute("name", api.getId() + "-" + "console");
        if (httpListenerConfigRef != null) {
            Element httpListener = new Element("listener", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            httpListener.setAttribute("config-ref", httpListenerConfigRef);
            httpListener.setAttribute("path", "/console/*");
            this.consoleFlow.addContent((Content)httpListener);
        } else {
            Element httpInboundEndpoint = new Element("inbound-endpoint", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            httpInboundEndpoint.setAttribute("address", "http://0.0.0.0:8081/console");
            this.consoleFlow.addContent((Content)httpInboundEndpoint);
        }
        Element restProcessor = new Element("console", APIKitTools.API_KIT_NAMESPACE.getNamespace());
        if (!StringUtils.isEmpty((String)configRef)) {
            restProcessor.setAttribute("config-ref", configRef);
        }
        this.consoleFlow.addContent((Content)restProcessor);
        mule.addContent((Content)this.consoleFlow);
    }

    @Override
    public Element generate() {
        return this.consoleFlow;
    }
}

