/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.mule.tools.apikit.input.parsers.HttpListenerConfigParser;
import org.mule.tools.apikit.model.HttpListenerConfig;

public class MuleDomainParser {
    private Map<String, HttpListenerConfig> httpListenerConfigs = new HashMap<String, HttpListenerConfig>();

    public MuleDomainParser(Log log, InputStream domainStream) {
        if (domainStream != null) {
            try {
                this.parseMuleDomainFile(domainStream);
            }
            catch (Exception e) {
                log.error((CharSequence)("Error parsing Mule domain file. Reason: " + e.getMessage()));
                log.debug((Throwable)e);
            }
        }
    }

    private void parseMuleDomainFile(InputStream stream) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document document = saxBuilder.build(stream);
        this.httpListenerConfigs = new HttpListenerConfigParser().parse(document);
    }

    public Map<String, HttpListenerConfig> getHttpListenerConfigs() {
        return this.httpListenerConfigs;
    }
}

