/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.MuleDomainParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.misc.FileListUtils;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.GenerationStrategy;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class Scaffolder {
    private final MuleConfigGenerator muleConfigGenerator;

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, null, null, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles, String domainFile) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, domainFile, null, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles, String domainFile, String muleVersion) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, domainFile, muleVersion, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specPaths, List<String> muleXmlPaths, String domainPath, String muleVersion, List<String> ramlsWithExtensionEnabledPaths) throws IOException {
        FileListUtils fileUtils = new FileListUtils(log);
        Map<File, InputStream> ramlStreams = fileUtils.toStreamsOrFail(specPaths);
        Map<File, InputStream> muleStreams = fileUtils.toStreamsOrFail(muleXmlPaths);
        TreeSet<File> ramlWithExtensionEnabled = new TreeSet<File>();
        if (ramlsWithExtensionEnabledPaths != null) {
            for (String ramlWithEE : ramlsWithExtensionEnabledPaths) {
                ramlWithExtensionEnabled.add(new File(ramlWithEE));
            }
        }
        InputStream domainStream = Scaffolder.getDomainStream(log, domainPath);
        return new Scaffolder(log, muleXmlOutputDirectory, ramlStreams, muleStreams, domainStream, muleVersion, ramlWithExtensionEnabled);
    }

    public Scaffolder(Log log, File muleXmlOutputDirectory, Map<File, InputStream> ramls, Map<File, InputStream> xmls, InputStream domainStream, String muleVersion, Set<File> ramlsWithExtensionEnabled) {
        MuleDomainParser muleDomainParser = new MuleDomainParser(log, domainStream);
        APIFactory apiFactory = new APIFactory(muleDomainParser.getHttpListenerConfigs());
        MuleConfigParser muleConfigParser = new MuleConfigParser(log, apiFactory).parse(ramls.keySet(), xmls);
        RAMLFilesParser RAMLFilesParser2 = new RAMLFilesParser(log, ramls, apiFactory, muleVersion);
        List<GenerationModel> generationModels = new GenerationStrategy(log).generate(RAMLFilesParser2, muleConfigParser);
        this.muleConfigGenerator = new MuleConfigGenerator(log, muleXmlOutputDirectory, generationModels, muleDomainParser.getHttpListenerConfigs(), muleVersion, ramlsWithExtensionEnabled);
    }

    private static InputStream getDomainStream(Log log, String domainPath) {
        FileInputStream domainStream = null;
        if (domainPath != null) {
            File domain = null;
            try {
                domain = new File(domainPath);
                domainStream = new FileInputStream(domain);
            }
            catch (FileNotFoundException e) {
                if (log != null) {
                    log.error((CharSequence)("Error opening file [" + domain + "] file"), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        return domainStream;
    }

    public void run() {
        this.muleConfigGenerator.generate();
    }
}

