/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.apache.commons.lang.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitConfigScope
implements Scope {
    private final Element mule;
    private final APIKitConfig config;
    private final String muleVersion;

    public APIKitConfigScope(APIKitConfig config, Element mule, String muleVersion) {
        this.mule = mule;
        this.config = config;
        this.muleVersion = muleVersion;
    }

    @Override
    public Element generate() {
        Element config = null;
        if (this.config != null) {
            config = new Element("config", APIKitTools.API_KIT_NAMESPACE.getNamespace());
            if (!StringUtils.isEmpty((String)this.config.getName())) {
                config.setAttribute("name", this.config.getName());
            }
            config.setAttribute("raml", this.config.getRaml());
            if (this.config.isExtensionEnabled() != null && APIKitTools.canExtensionsBeEnabled(this.muleVersion)) {
                config.setAttribute("extensionEnabled", String.valueOf(this.config.isExtensionEnabled()));
            }
            config.setAttribute("consoleEnabled", String.valueOf(this.config.isConsoleEnabled()));
            if (this.config.isConsoleEnabled()) {
                config.setAttribute("consolePath", this.config.getConsolePath());
            }
            this.mule.addContent((Content)config);
        }
        return config;
    }
}

