/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.mule.tools.apikit.input.parsers.APIKitConfigParser;
import org.mule.tools.apikit.input.parsers.APIKitFlowsParser;
import org.mule.tools.apikit.input.parsers.APIKitRoutersParser;
import org.mule.tools.apikit.input.parsers.HttpListenerConfigParser;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;

public class MuleConfigParser {
    private Set<ResourceActionMimeTypeTriplet> entries = new HashSet<ResourceActionMimeTypeTriplet>();
    private Map<String, API> includedApis = new HashMap<String, API>();
    private Map<String, HttpListenerConfig> httpListenerConfigs = new HashMap<String, HttpListenerConfig>();
    private Map<String, APIKitConfig> apikitConfigs = new HashMap<String, APIKitConfig>();
    private final APIFactory apiFactory;
    private final Log log;

    public MuleConfigParser(Log log, APIFactory apiFactory) {
        this.apiFactory = apiFactory;
        this.httpListenerConfigs.putAll(apiFactory.getDomainHttpListenerConfigs());
        this.log = log;
    }

    public MuleConfigParser parse(Set<File> ramlPaths, Map<File, InputStream> streams) {
        Map<File, Document> configurations = this.createDocuments(streams);
        for (Document document : configurations.values()) {
            this.parseConfigs(document);
        }
        for (Map.Entry entry : configurations.entrySet()) {
            Document document = (Document)entry.getValue();
            File file = (File)entry.getKey();
            this.parseApis(file, document, ramlPaths);
        }
        this.parseFlows(configurations.values());
        return this;
    }

    protected void parseApis(File file, Document document, Set<File> ramlPaths) {
        this.includedApis.putAll((Map<String, API>)new APIKitRoutersParser(this.apikitConfigs, this.httpListenerConfigs, ramlPaths, file, this.apiFactory).parse(document));
    }

    protected void parseConfigs(Document document) {
        this.apikitConfigs.putAll((Map<String, APIKitConfig>)new APIKitConfigParser().parse(document));
        this.httpListenerConfigs.putAll((Map<String, HttpListenerConfig>)new HttpListenerConfigParser().parse(document));
    }

    protected void parseFlows(Collection<Document> documents) {
        for (Document document : documents) {
            try {
                this.entries.addAll((Collection<ResourceActionMimeTypeTriplet>)new APIKitFlowsParser(this.log, this.includedApis).parse(document));
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error parsing Mule xml config file. Reason: " + e.getMessage()));
                this.log.debug((Throwable)e);
            }
        }
    }

    protected Map<File, Document> createDocuments(Map<File, InputStream> streams) {
        HashMap<File, Document> result = new HashMap<File, Document>();
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        for (Map.Entry<File, InputStream> fileStreamEntry : streams.entrySet()) {
            InputStream stream = fileStreamEntry.getValue();
            try {
                Document document = saxBuilder.build(stream);
                stream.close();
                result.put(fileStreamEntry.getKey(), document);
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error parsing Mule xml config file: [" + fileStreamEntry.getKey() + "]. Reason: " + e.getMessage()));
                this.log.debug((Throwable)e);
            }
        }
        return result;
    }

    public Map<String, APIKitConfig> getApikitConfigs() {
        return this.apikitConfigs;
    }

    public Set<ResourceActionMimeTypeTriplet> getEntries() {
        return this.entries;
    }

    public Set<API> getIncludedApis() {
        HashSet<API> apis = new HashSet<API>();
        apis.addAll(this.includedApis.values());
        return apis;
    }
}

