/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.deployer;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.mule.tools.apikit.output.deployer.MuleDeployProperties;

public class MuleDeployPropertiesWriter {
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";
    private static final String DEPLOYMENT_DESCRIPTOR_AUTOGENERATED = "#** GENERATED CONTENT ** Mule Application Deployment Descriptor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(MuleDeployProperties deployProperties, File propertiesFile) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(propertiesFile);
            writer.println(DEPLOYMENT_DESCRIPTOR_AUTOGENERATED);
            MuleDeployPropertiesWriter.printProperty(writer, "domain", deployProperties.getDomain());
            if (!deployProperties.getConfigResources().isEmpty()) {
                MuleDeployPropertiesWriter.printProperty(writer, "config.resources", MuleDeployPropertiesWriter.stringify(deployProperties.getConfigResources()));
            }
            MuleDeployPropertiesWriter.printProperty(writer, "redeployment.enabled", deployProperties.isRedeploymentEnabled());
            MuleDeployPropertiesWriter.printProperty(writer, "encoding", deployProperties.getEncoding());
            MuleDeployPropertiesWriter.printProperty(writer, "config.builder", deployProperties.getConfigurationBuilder());
            MuleDeployPropertiesWriter.printProperty(writer, "loader.override", deployProperties.getLoaderOverride());
            MuleDeployPropertiesWriter.printProperty(writer, "scan.packages", deployProperties.getPackagesToScan());
            writer.close();
        }
    }

    private static String formatNow() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(now.getTime());
    }

    private static void printProperty(PrintWriter writer, String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            writer.println(propertyName + "=" + propertyValue);
        }
    }

    private static String stringify(List<String> configResources) {
        StringBuilder builder = new StringBuilder("");
        for (String configResource : configResources) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(configResource);
        }
        return builder.toString();
    }
}

