/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.deployer;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.spi.deployer.AbstractEmbeddedLocalDeployer;
import org.mule.module.launcher.DeploymentListener;
import org.mule.tools.cargo.container.Mule3xEmbeddedLocalContainer;
import org.mule.tools.cargo.deployable.AbstractMuleDeployable;
import org.mule.tools.cargo.deployable.MuleApplicationDeployable;

public class EmbeddedDeployer
extends AbstractEmbeddedLocalDeployer {
    public EmbeddedDeployer(EmbeddedLocalContainer container) {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Deployable deployable) {
        this.getLogger().info("Deploying deployable", ((Object)((Object)this)).getClass().getName());
        if (!((Mule3xEmbeddedLocalContainer)this.getContainer()).hasBeenStarted()) {
            throw new ContainerException("The container has not been started, cannot deploy. Add the start goal to your config.");
        }
        if (!(deployable instanceof MuleApplicationDeployable)) {
            throw new IllegalArgumentException("Deployable type <" + deployable.getType() + "> is not supported!");
        }
        try {
            final CauseHolder applicationFailCause = new CauseHolder();
            final String applicationName = ((AbstractMuleDeployable)deployable).getApplicationName();
            File targetCopy = new File(((Mule3xEmbeddedLocalContainer)this.getContainer()).getMuleHome(), FilenameUtils.getName((String)deployable.getFile()));
            FileUtils.getFileUtils().copyFile(new File(deployable.getFile()), targetCopy);
            Object deploymentService = this.getDeploymentService();
            Object lock = this.getDeploymentLock(deploymentService);
            Object compositeDeploymentListener = this.getCompositeDeploymentListener(deploymentService);
            compositeDeploymentListener.getClass().getMethod("addDeploymentListener", DeploymentListener.class).invoke(compositeDeploymentListener, new DeploymentListener(){

                public void onDeploymentStart(String appName) {
                }

                public void onDeploymentSuccess(String appName) {
                }

                public void onDeploymentFailure(String appName, Throwable cause) {
                    if (appName.equals(applicationName)) {
                        applicationFailCause.setCause(cause);
                    }
                }

                public void onUndeploymentStart(String appName) {
                }

                public void onUndeploymentSuccess(String appName) {
                }

                public void onUndeploymentFailure(String appName, Throwable cause) {
                }
            });
            Method tryLock = lock.getClass().getMethod("tryLock", Long.TYPE, TimeUnit.class);
            try {
                tryLock.invoke(lock, new Object[]{60L, TimeUnit.SECONDS});
                deploymentService.getClass().getMethod("deploy", URL.class).invoke(deploymentService, targetCopy.toURI().toURL());
            }
            catch (Exception nee) {
                if (applicationFailCause.getCause() != null && applicationFailCause.getCause() instanceof Exception) {
                    throw (Exception)applicationFailCause.getCause();
                }
            }
            finally {
                lock.getClass().getMethod("unlock", new Class[0]).invoke(lock, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Unable to deploy", (Throwable)e);
        }
    }

    public void start(Deployable deployable) {
        this.getLogger().info("Starting deployable", ((Object)((Object)this)).getClass().getName());
    }

    public void stop(Deployable deployable) {
        this.getLogger().info("Stopping deployable", ((Object)((Object)this)).getClass().getName());
    }

    public void undeploy(Deployable deployable) {
        try {
            String applicationName = ((AbstractMuleDeployable)deployable).getApplicationName();
            Object deploymentService = this.getDeploymentService();
            Object lock = this.getDeploymentLock(deploymentService);
            Method tryLock = lock.getClass().getMethod("tryLock", Long.TYPE, TimeUnit.class);
            try {
                tryLock.invoke(lock, new Object[]{60L, TimeUnit.SECONDS});
                deploymentService.getClass().getMethod("undeploy", String.class).invoke(deploymentService, applicationName);
            }
            catch (Exception nee) {
                throw new ContainerException("Unable to undeploy", (Throwable)nee);
            }
            finally {
                lock.getClass().getMethod("unlock", new Class[0]).invoke(lock, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Unable to undeploy", (Throwable)e);
        }
    }

    private Object getDeploymentStatusTracker(Object deploymentService) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object deploymentListener = this.getCompositeDeploymentListener(deploymentService);
        Field deploymentListenersField = deploymentListener.getClass().getDeclaredField("deploymentListeners");
        deploymentListenersField.setAccessible(true);
        Object deploymentListeners = deploymentListenersField.get(deploymentListener);
        int size = (Integer)deploymentListeners.getClass().getMethod("size", new Class[0]).invoke(deploymentListeners, new Object[0]);
        for (int i = 0; i < size; ++i) {
            Object innerDeploymentListener = deploymentListeners.getClass().getMethod("get", Integer.TYPE).invoke(deploymentListeners, i);
            if (!innerDeploymentListener.getClass().getName().equals("org.mule.module.launcher.DeploymentStatusTracker")) continue;
            return innerDeploymentListener;
        }
        return null;
    }

    private Object getCompositeDeploymentListener(Object deploymentService) throws NoSuchFieldException, IllegalAccessException {
        Field deploymentListenerField = deploymentService.getClass().getDeclaredField("deploymentListener");
        deploymentListenerField.setAccessible(true);
        return deploymentListenerField.get(deploymentService);
    }

    private Object getDeploymentLock(Object deploymentService) throws NoSuchFieldException, IllegalAccessException {
        Field lockField = deploymentService.getClass().getDeclaredField("lock");
        lockField.setAccessible(true);
        return lockField.get(deploymentService);
    }

    private Object getDeploymentService() throws Exception {
        Field deploymentServiceField = ((Mule3xEmbeddedLocalContainer)this.getContainer()).getServer().getClass().getDeclaredField("deploymentService");
        deploymentServiceField.setAccessible(true);
        return deploymentServiceField.get(((Mule3xEmbeddedLocalContainer)this.getContainer()).getServer());
    }

    private static class CauseHolder {
        private Throwable cause;

        private CauseHolder() {
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }
    }
}

