/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container;

import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.mule.tools.cargo.container.MuleContainerCapability;

public class Mule3xEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    public static final String ID = "mule3x";
    public static final String NAME = "Mule 3.x Embedded";
    private Object server;
    private String muleHome;
    private static String LOG4J_PROPERTIES = "log4j.properties";
    private AtomicBoolean started = new AtomicBoolean(false);

    public Mule3xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public final String getId() {
        return ID;
    }

    public final String getName() {
        return NAME;
    }

    public final ContainerCapability getCapability() {
        return new MuleContainerCapability();
    }

    public final Object getServer() throws Exception {
        if (this.server == null) {
            this.createServerObject();
        }
        return this.server;
    }

    protected final Deployable getDeployable() {
        List deployables = this.getConfiguration().getDeployables();
        if (deployables.isEmpty()) {
            throw new IllegalArgumentException("No " + Deployable.class.getSimpleName() + " defined");
        }
        if (deployables.size() != 1) {
            throw new IllegalArgumentException("Only supports a single " + Deployable.class.getSimpleName());
        }
        return (Deployable)deployables.get(0);
    }

    protected final void configureLog4j() {
        String log4jProperties = this.getConfiguration().getPropertyValue(LOG4J_PROPERTIES);
        if (log4jProperties == null) {
            Logger root = Logger.getRootLogger();
            root.setLevel(Level.INFO);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("[%p] %m%n")));
        } else {
            PropertyConfigurator.configure((String)log4jProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this.getConfiguration().getProperties().containsKey("cargo.mule.spring.profile")) {
            System.setProperty("spring.profiles.active", (String)this.getConfiguration().getProperties().get("cargo.mule.spring.profile"));
        }
        if (this.getConfiguration().getProperties().containsKey("cargo.mule.http.port")) {
            System.setProperty("http.port", (String)this.getConfiguration().getProperties().get("cargo.mule.http.port"));
        }
        this.configureLog4j();
        this.setMuleHome();
        System.setProperty("mule.simpleLog", "true");
        SecurityManager previousSecurityManager = System.getSecurityManager();
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName() != null && permission.getName().startsWith("exitVM")) {
                    throw new SecurityException();
                }
            }
        };
        System.setSecurityManager(securityManager);
        try {
            this.startContainer();
        }
        catch (SecurityException securityException) {
        }
        finally {
            System.setSecurityManager(previousSecurityManager);
        }
        this.started.set(true);
    }

    public String getMuleHome() {
        return this.muleHome;
    }

    public boolean hasBeenStarted() {
        return this.started.get();
    }

    private void setMuleHome() throws IOException {
        String fakeMuleHome = this.createFakeMuleHomeDirectory().getAbsolutePath();
        this.getLogger().debug("Fake Mule Home: " + fakeMuleHome, ((Object)((Object)this)).getClass().getName());
        System.setProperty("mule.home", fakeMuleHome);
        this.muleHome = fakeMuleHome;
    }

    private void startContainer() throws Exception {
        this.getServer().getClass().getMethod("start", Boolean.TYPE).invoke(this.getServer(), false);
    }

    protected final void waitForCompletion(boolean waitForStarting) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            SecurityManager previousSecurityManager = System.getSecurityManager();
            SecurityManager securityManager = new SecurityManager(){

                @Override
                public void checkPermission(Permission permission) {
                    if (permission.getName() != null && permission.getName().startsWith("exitVM")) {
                        throw new SecurityException();
                    }
                }
            };
            System.setSecurityManager(securityManager);
            try {
                this.getServer().getClass().getMethod("shutdown", new Class[0]).invoke(this.getServer(), new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            finally {
                System.setSecurityManager(previousSecurityManager);
            }
            new File(this.muleHome).deleteOnExit();
        }
        catch (Exception exception) {
        }
        finally {
            this.started.set(false);
        }
    }

    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            try {
                this.server = this.getClassLoader().loadClass("org.mule.module.launcher.MuleContainer").newInstance();
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Mule container", (Throwable)e);
            }
        }
    }

    public File createFakeMuleHomeDirectory() throws IOException {
        File fakeMuleHome = File.createTempFile("fakeMuleHome", Long.toString(System.nanoTime()));
        File fakeAppsDir = new File(fakeMuleHome, "apps");
        File fakeLibDir = new File(fakeMuleHome, "lib/shared/default");
        if (!fakeMuleHome.delete() || !fakeMuleHome.mkdir()) {
            throw new IOException("Could not create fake mule home: " + fakeMuleHome.getAbsolutePath());
        }
        if (!fakeAppsDir.mkdir()) {
            throw new IOException("Could not create fake apps home: " + fakeAppsDir.getAbsolutePath());
        }
        if (!fakeLibDir.mkdirs()) {
            throw new IOException("Could not create fake lib dir: " + fakeLibDir.getAbsolutePath());
        }
        return fakeMuleHome;
    }
}

