/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.io.File;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.tools.maven.plugin.AbstractCloudHubMojo;
import org.mule.tools.maven.plugin.cloudhub.CloudHubAdapter;

public class CloudHubDeployMojo
extends AbstractCloudHubMojo {
    private static final String LATEST_MULE_ESB_VERSION = "3.3.1";
    static final String MULE_TYPE = "mule";
    protected int workers;
    protected String muleVersion;
    protected long maxWaitTime;
    protected Map<String, String> properties;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        String muleVersionProperty;
        String type = this.project.getArtifact().getType();
        if (!MULE_TYPE.equals(type)) {
            throw new IllegalArgumentException("Only supports mule packaging type, not <" + type + ">.");
        }
        if (this.project.getAttachedArtifacts().isEmpty()) {
            throw new IllegalArgumentException("No Mule application attached. This probably means `package` phase has not been executed.");
        }
        File file = ((Artifact)this.project.getAttachedArtifacts().get(0)).getFile();
        this.getLog().info((CharSequence)("Deploying <" + file + ">"));
        if (this.muleVersion == null) {
            for (Object o : this.project.getDependencies()) {
                Dependency dependency = (Dependency)o;
                if (!"org.mule".equals(dependency.getGroupId()) || !"mule-core".equals(dependency.getArtifactId())) continue;
                this.muleVersion = dependency.getVersion();
                break;
            }
        }
        if (this.muleVersion == null && (muleVersionProperty = this.project.getProperties().getProperty("mule.version")) != null && "".equals(muleVersionProperty)) {
            this.muleVersion = muleVersionProperty;
        }
        if (this.muleVersion == null) {
            this.muleVersion = LATEST_MULE_ESB_VERSION;
        }
        CloudHubAdapter adapter = this.createDomainConnection();
        adapter.deploy(file, this.muleVersion, this.workers, this.maxWaitTime, this.properties);
    }
}

