/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.tools.maven.plugin.cloudhub.CloudHubAdapter;

public abstract class AbstractCloudHubMojo
extends AbstractMojo {
    private static final String URL_LAYOUT = ".*://(.*)(/+)";
    protected String cloudHubUrl;
    protected String domain;
    protected String username;
    protected String password;
    private Settings settings;
    private CloudHubAdapter cloudHubAdapter;

    protected Server getServer() throws MojoExecutionException {
        return this.settings.getServer(this.normalize(this.cloudHubUrl));
    }

    protected String normalize(String url) throws MojoExecutionException {
        Pattern pattern = Pattern.compile(URL_LAYOUT);
        Matcher matcher = pattern.matcher(url);
        if (!matcher.matches()) {
            throw new MojoExecutionException("Invalid URL <" + url + ">");
        }
        return matcher.group(1);
    }

    protected String getUsername() throws MojoExecutionException {
        if (this.username != null) {
            return this.username;
        }
        Server server = this.getServer();
        if (server == null) {
            throw new MojoExecutionException("Failed to extract username from server settings");
        }
        return server.getUsername();
    }

    protected String getPassword() throws MojoExecutionException {
        if (this.password != null) {
            return this.password;
        }
        Server server = this.getServer();
        if (server == null) {
            throw new MojoExecutionException("Failed to extract password from server settings");
        }
        return server.getPassword();
    }

    protected CloudHubAdapter createDomainConnection() throws MojoExecutionException {
        this.cloudHubAdapter.create(this.cloudHubUrl, this.getUsername(), this.getPassword(), this.domain);
        return this.cloudHubAdapter;
    }
}

