/*
 * $Id$
 */

package com.javaforge.bobber.archetype.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *              Represents a template in the archetype to be
 * processed
 *           .
 * 
 * @version $Revision$ $Date$
 */
public class Template implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field file.
     */
    private String file;

    /**
     * Field output.
     */
    private String output;

    /**
     * If the specified variable is true, the template will be
     * processed, otherwise skipped.
     */
    private String dependsOnVar;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get if the specified variable is true, the template will be
     * processed, otherwise skipped.
     * 
     * @return String
     */
    public String getDependsOnVar()
    {
        return this.dependsOnVar;
    } //-- String getDependsOnVar() 

    /**
     * Get the file field.
     * 
     * @return String
     */
    public String getFile()
    {
        return this.file;
    } //-- String getFile() 

    /**
     * Get the output field.
     * 
     * @return String
     */
    public String getOutput()
    {
        return this.output;
    } //-- String getOutput() 

    /**
     * Set if the specified variable is true, the template will be
     * processed, otherwise skipped.
     * 
     * @param dependsOnVar
     */
    public void setDependsOnVar(String dependsOnVar)
    {
        this.dependsOnVar = dependsOnVar;
    } //-- void setDependsOnVar(String) 

    /**
     * Set the file field.
     * 
     * @param file
     */
    public void setFile(String file)
    {
        this.file = file;
    } //-- void setFile(String) 

    /**
     * Set the output field.
     * 
     * @param output
     */
    public void setOutput(String output)
    {
        this.output = output;
    } //-- void setOutput(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
