/*
 * $Id$
 */

package com.javaforge.bobber.archetype.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the assembly layout and packaging.
 * 
 * @version $Revision$ $Date$
 */
public class BobberArchetype implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private String id;

    /**
     * Field allowPartial.
     */
    private boolean allowPartial = false;

    /**
     * Field variables.
     */
    private java.util.List variables;

    /**
     * Field templates.
     */
    private java.util.List templates;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addTemplate.
     * 
     * @param template
     */
    public void addTemplate(Template template)
    {
        if ( !(template instanceof Template) )
        {
            throw new ClassCastException( "BobberArchetype.addTemplates(template) parameter must be instanceof " + Template.class.getName() );
        }
        getTemplates().add( template );
    } //-- void addTemplate(Template) 

    /**
     * Method addVariable.
     * 
     * @param variable
     */
    public void addVariable(Variable variable)
    {
        if ( !(variable instanceof Variable) )
        {
            throw new ClassCastException( "BobberArchetype.addVariables(variable) parameter must be instanceof " + Variable.class.getName() );
        }
        getVariables().add( variable );
    } //-- void addVariable(Variable) 

    /**
     * Get the id field.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getTemplates.
     * 
     * @return java.util.List
     */
    public java.util.List getTemplates()
    {
        if ( this.templates == null )
        {
            this.templates = new java.util.ArrayList();
        }
        
        return this.templates;
    } //-- java.util.List getTemplates() 

    /**
     * Method getVariables.
     * 
     * @return java.util.List
     */
    public java.util.List getVariables()
    {
        if ( this.variables == null )
        {
            this.variables = new java.util.ArrayList();
        }
        
        return this.variables;
    } //-- java.util.List getVariables() 

    /**
     * Get the allowPartial field.
     * 
     * @return boolean
     */
    public boolean isAllowPartial()
    {
        return this.allowPartial;
    } //-- boolean isAllowPartial() 

    /**
     * Method removeTemplate.
     * 
     * @param template
     */
    public void removeTemplate(Template template)
    {
        if ( !(template instanceof Template) )
        {
            throw new ClassCastException( "BobberArchetype.removeTemplates(template) parameter must be instanceof " + Template.class.getName() );
        }
        getTemplates().remove( template );
    } //-- void removeTemplate(Template) 

    /**
     * Method removeVariable.
     * 
     * @param variable
     */
    public void removeVariable(Variable variable)
    {
        if ( !(variable instanceof Variable) )
        {
            throw new ClassCastException( "BobberArchetype.removeVariables(variable) parameter must be instanceof " + Variable.class.getName() );
        }
        getVariables().remove( variable );
    } //-- void removeVariable(Variable) 

    /**
     * Set the allowPartial field.
     * 
     * @param allowPartial
     */
    public void setAllowPartial(boolean allowPartial)
    {
        this.allowPartial = allowPartial;
    } //-- void setAllowPartial(boolean) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             list of all the templates in the archetype that
     * need to 
     *           .
     * 
     * @param templates
     */
    public void setTemplates(java.util.List templates)
    {
        this.templates = templates;
    } //-- void setTemplates(java.util.List) 

    /**
     * Set 
     *              variable expressions that will use the
     * System.properties values to be used as input into the
     * velocity template engine
     *           .
     * 
     * @param variables
     */
    public void setVariables(java.util.List variables)
    {
        this.variables = variables;
    } //-- void setVariables(java.util.List) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
