/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container;

import java.io.File;
import java.net.URLClassLoader;
import java.security.Permission;
import org.apache.log4j.PropertyConfigurator;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.mule.module.launcher.MuleContainer;
import org.mule.module.reboot.DefaultMuleClassPathConfig;
import org.mule.module.reboot.MuleContainerBootstrap;
import org.mule.module.reboot.MuleContainerSystemClassLoader;
import org.mule.tools.cargo.container.MuleContainerCapability;

public class Mule3xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "mule3x";
    public static final String NAME = "Mule 3.x Installed";
    private static final String MULE_HOME = "mule.home";
    private static final String MULE_BASE = "mule.base";
    private MuleContainer container;

    public Mule3xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ContainerCapability getCapability() {
        return new MuleContainerCapability();
    }

    protected URLClassLoader createContainerSystemClassLoader() throws Exception {
        File muleHome = MuleContainerBootstrap.lookupMuleHome();
        File muleBase = MuleContainerBootstrap.lookupMuleBase();
        DefaultMuleClassPathConfig config = new DefaultMuleClassPathConfig(muleHome, muleBase);
        return new MuleContainerSystemClassLoader(config);
    }

    protected MuleContainer createContainer() {
        return new MuleContainer();
    }

    protected final synchronized MuleContainer getContainer() {
        if (this.container == null) {
            this.container = this.createContainer();
        }
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(Java java) throws Exception {
        System.setProperty(MULE_HOME, this.getHome());
        System.setProperty(MULE_BASE, this.getHome());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.createContainerSystemClassLoader());
        try {
            PropertyConfigurator.configure((String)(this.getHome() + "/conf/log4j.properties"));
            this.getContainer().start(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(Java java) throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission prmsn) {
                }

                @Override
                public void checkExit(int i) {
                    throw new IllegalArgumentException();
                }
            });
            try {
                this.getContainer().shutdown();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            System.setSecurityManager(securityManager);
        }
    }
}

