/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.deployer;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.Base64;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableException;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.spi.deployer.AbstractDeployer;
import org.mule.tools.cargo.container.IONContainer;
import org.mule.tools.cargo.container.configuration.IONConfiguration;
import org.mule.tools.cargo.deployable.AbstractMuleDeployable;
import org.mule.tools.cargo.deployer.Application;

public class IONDeployer
extends AbstractDeployer {
    private static final String DEFAULT_ION_URL = "https://muleion.com/";
    private final IONContainer container;
    private final Client client;
    private long maxWaitTime = 120000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 120000L;
    private static final String LOG_DEPLOY_CATEGORY = "ion:deploy";
    private static final String LOG_UNDEPLOY_CATEGORY = "ion:undeploy";

    public IONDeployer(RemoteContainer container) {
        super((Container)container);
        if (!(container instanceof IONContainer)) {
            throw new IllegalArgumentException("Only accept " + IONContainer.class.getSimpleName());
        }
        this.container = (IONContainer)container;
        this.container.getConfiguration().validate();
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.client = Client.create((ClientConfig)clientConfig);
    }

    public DeployerType getType() {
        return DeployerType.REMOTE;
    }

    protected final String getIONURL() {
        String ionURL = this.getConfiguration().getIONURL();
        if (ionURL == null) {
            return DEFAULT_ION_URL;
        }
        return ionURL;
    }

    protected final String getIONApplicationsResource() {
        return this.getIONURL() + "api/applications/";
    }

    protected final WebResource.Builder createBuilder(String path) {
        WebResource webResource = this.client.resource(this.getIONApplicationsResource());
        return webResource.path(path).header("Authorization", (Object)("Basic " + new String(Base64.encode((String)(this.getConfiguration().getUserName() + ":" + this.getConfiguration().getPassword())), Charset.forName("ASCII"))));
    }

    protected final IONConfiguration getConfiguration() {
        return this.container.getConfiguration();
    }

    protected final Application getIONApplication(String domain) {
        return (Application)((WebResource.Builder)this.createBuilder(domain).type(MediaType.APPLICATION_JSON_TYPE)).get(Application.class);
    }

    protected final boolean isIONApplicationCreated(String domain) {
        try {
            this.getIONApplication(domain);
            return true;
        }
        catch (UniformInterfaceException e) {
            return false;
        }
    }

    protected final void updateIONApplication(String domain, Application application) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createBuilder(domain).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)application);
        ClientResponse.Status status = response.getClientResponseStatus();
        if (status != ClientResponse.Status.OK && status != ClientResponse.Status.CREATED) {
            throw new DeployableException("Failed to update <" + domain + ">: " + status.getStatusCode() + "(" + status.getReasonPhrase() + "): " + this.extractFailureReason(response));
        }
    }

    protected final void ensureIONApplicationExists(String domain) {
        if (!this.isIONApplicationCreated(domain)) {
            throw new DeployableException("iON Application <" + domain + "> does not exit on <" + this.getConfiguration().getIONURL() + ">");
        }
    }

    protected final String extractFailureReason(ClientResponse response) {
        if (response.getType() != null && response.getType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return ((Map)response.getEntity(Map.class)).get("message").toString();
        }
        return (String)response.getEntity(String.class);
    }

    protected void sleep() {
    }

    public void deploy(Deployable deployable) {
        String domain = this.getConfiguration().getDomain();
        this.ensureIONApplicationExists(domain);
        this.getLogger().info("Deploying <" + deployable.getFile() + ">", LOG_DEPLOY_CATEGORY);
        Application application = this.getIONApplication(domain);
        switch (application.getStatus()) {
            case STARTED: 
            case UNDEPLOYED: 
            case DEPLOY_FAILED: {
                int workers = this.getConfiguration().getWorkers();
                if (application.getWorkers() == workers) {
                    this.getLogger().info("Forcing redeployment", LOG_DEPLOY_CATEGORY);
                } else {
                    this.getLogger().info("Scaling workers to <" + workers + ">", LOG_DEPLOY_CATEGORY);
                    application.setWorkers(workers);
                }
                if (!this.getConfiguration().getMuleVersion().equals(application.getMuleVersion())) {
                    application.setMuleVersion(this.getConfiguration().getMuleVersion());
                }
                application.setFilename(((AbstractMuleDeployable)((Object)AbstractMuleDeployable.class.cast(deployable))).getApplicationName() + ".zip");
                this.updateIONApplication(domain, application);
                ClientResponse.Status status = ((ClientResponse)((WebResource.Builder)this.createBuilder(domain + "/deploy").type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).post(ClientResponse.class, (Object)new File(deployable.getFile()))).getClientResponseStatus();
                if (status == ClientResponse.Status.OK) break;
                throw new DeployableException("Failed to deploy <" + domain + ">: " + status.getStatusCode() + "(" + status.getReasonPhrase() + ")");
            }
            case DEPLOYING: {
                throw new DeployableException("Another deployment is in progress");
            }
            default: {
                throw new DeployableException("Unhandled status <" + (Object)((Object)application.getStatus()) + ">");
            }
        }
        this.getLogger().info("Waiting for deployment", LOG_DEPLOY_CATEGORY);
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < this.maxWaitTime) {
            switch (this.getIONApplication(domain).getStatus()) {
                case DEPLOY_FAILED: {
                    throw new DeployableException("Failed to deploy <" + deployable.getFile() + "> on <" + this.getConfiguration().getDomain() + ">");
                }
                case STARTED: {
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        throw new DeployableException("Waited on <" + this.getConfiguration().getDomain() + "> deployment for <" + this.maxWaitTime + "> ms");
    }

    public void undeploy(Deployable deployable) {
        String domain = this.getConfiguration().getDomain();
        this.ensureIONApplicationExists(domain);
        Application application = this.getIONApplication(domain);
        application.setWorkers(0);
        this.getLogger().info("Updating <" + domain + ">", LOG_UNDEPLOY_CATEGORY);
        this.updateIONApplication(domain, application);
        this.getLogger().info("Waiting for undeployment", LOG_UNDEPLOY_CATEGORY);
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < this.maxWaitTime) {
            if (this.getIONApplication(domain).getWorkerStatuses().isEmpty()) {
                this.getLogger().info("Undeployed in <" + (System.currentTimeMillis() - before) + "> ms", LOG_UNDEPLOY_CATEGORY);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        throw new DeployableException("Waited on <" + this.getConfiguration().getDomain() + "> undeployment for <" + this.maxWaitTime + "> ms");
    }
}

