/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.security.Permission;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.mule.module.launcher.MuleContainer;
import org.mule.module.reboot.DefaultMuleClassPathConfig;
import org.mule.module.reboot.MuleContainerBootstrap;
import org.mule.module.reboot.MuleContainerSystemClassLoader;
import org.mule.tools.cargo.container.MuleContainerCapability;

public class Mule3xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "mule3x";
    public static final String NAME = "Mule 3.x Installed";
    private static final String MULE_HOME = "mule.home";
    private static final String MULE_BASE = "mule.base";
    private static final String LOG_CATEGORY = "mule:installed";
    private Object container;
    private static final String MULE_CONTAINER_CLASSNAME = "org.mule.module.launcher.MuleContainer";

    public Mule3xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ContainerCapability getCapability() {
        return new MuleContainerCapability();
    }

    protected final URLClassLoader createContainerSystemClassLoader() throws Exception {
        final File muleHome = MuleContainerBootstrap.lookupMuleHome();
        File muleBase = MuleContainerBootstrap.lookupMuleBase();
        DefaultMuleClassPathConfig config = new DefaultMuleClassPathConfig(muleHome, muleBase){
            {
                super(x0, x1);
                this.addLibraryDirectory(muleHome, "/lib/boot");
                this.addLibraryDirectory(muleHome, "/lib/conf");
            }
        };
        return new MuleContainerSystemClassLoader(config);
    }

    protected MuleContainer createContainer() {
        return new MuleContainer();
    }

    protected final void ensureValidMuleHome(String home) {
        File homeFile = new File(this.getHome());
        if (!homeFile.exists() || !homeFile.isDirectory()) {
            throw new IllegalArgumentException("Invalid mule home <" + home + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(Java java) throws Exception {
        String home = this.getHome();
        this.ensureValidMuleHome(home);
        this.getLogger().info("Using mule installation <" + home + ">", LOG_CATEGORY);
        System.setProperty(MULE_HOME, home);
        System.setProperty(MULE_BASE, home);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader muleClassLoader = this.createContainerSystemClassLoader();
        Thread.currentThread().setContextClassLoader(muleClassLoader);
        try {
            Class<?> muleClass = Thread.currentThread().getContextClassLoader().loadClass(MULE_CONTAINER_CLASSNAME);
            Constructor<?> c = muleClass.getConstructor(new Class[0]);
            this.container = c.newInstance(new Object[0]);
            Method startMethod = muleClass.getMethod("start", Boolean.TYPE);
            startMethod.invoke(this.container, false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(Java java) throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            final RuntimeException exception = new RuntimeException();
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission permission) {
                }

                @Override
                public void checkExit(int i) {
                    throw exception;
                }
            });
            try {
                Method shutdownMethod = this.container.getClass().getMethod("shutdown", new Class[0]);
                shutdownMethod.invoke(this.container, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != exception) {
                    throw e;
                }
            }
        }
        finally {
            System.setSecurityManager(securityManager);
        }
    }
}

