/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container.configuration;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractRuntimeConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfigurationCapability;

public class IONConfiguration
extends AbstractRuntimeConfiguration {
    private static final String DOMAIN_PROPERTY = "domain";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String WORKERS_PROPERTY = "workers";
    private static final int WORKERS_DEFAULT = 1;

    public ConfigurationCapability getCapability() {
        return new AbstractStandaloneLocalConfigurationCapability(){

            protected Map<String, Boolean> getPropertySupportMap() {
                HashMap<String, Boolean> propertySupportMap = new HashMap<String, Boolean>();
                return propertySupportMap;
            }
        };
    }

    public final String getDomain() {
        return this.getPropertyValue(DOMAIN_PROPERTY);
    }

    public final String getUserName() {
        return this.getPropertyValue(USERNAME_PROPERTY);
    }

    public final String getPassword() {
        return this.getPropertyValue(PASSWORD_PROPERTY);
    }

    public final int getWorkers() {
        String workersProperty = this.getPropertyValue(WORKERS_PROPERTY);
        if (workersProperty == null) {
            return 1;
        }
        int workers = Integer.valueOf(workersProperty);
        if (workers < 0 || workers > 2) {
            throw new IllegalArgumentException("Workers must be >= 0 and <= 2");
        }
        return workers;
    }

    protected final void ensurePropertyProvided(String property) {
        if (this.getPropertyValue(property) == null) {
            throw new IllegalArgumentException("Missing required " + property + " property");
        }
    }

    public final void validate() {
        this.ensurePropertyProvided(DOMAIN_PROPERTY);
        this.ensurePropertyProvided(USERNAME_PROPERTY);
        this.ensurePropertyProvided(PASSWORD_PROPERTY);
    }
}

