/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.mule.MuleServer;
import org.mule.tools.cargo.container.MuleContainerCapability;
import org.mule.tools.cargo.deployable.MuleApplicationDeployable;
import org.mule.tools.cargo.deployable.MuleConfigurationDeployable;

public class Mule3xEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    public static final String ID = "mule3x";
    public static final String NAME = "Mule 3.x Embedded";
    private MuleServer server;
    private static String LOG4J_PROPERTIES = "log4j.properties";

    public Mule3xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public final String getId() {
        return ID;
    }

    public final String getName() {
        return NAME;
    }

    public final ContainerCapability getCapability() {
        return new MuleContainerCapability(){

            @Override
            public boolean supportsDeployableType(DeployableType type) {
                return MuleConfigurationDeployable.getDeployableType().equals((Object)type) || super.supportsDeployableType(type);
            }
        };
    }

    protected final MuleServer getServer() {
        return this.server;
    }

    protected final void startServer(String config) {
        MuleServer muleServer = config == null ? new MuleServer() : new MuleServer(config);
        muleServer.start(false, false);
        this.server = muleServer;
    }

    protected final Deployable getDeployable() {
        List deployables = this.getConfiguration().getDeployables();
        if (deployables.isEmpty()) {
            throw new IllegalArgumentException("No " + Deployable.class.getSimpleName() + " defined");
        }
        if (deployables.size() != 1) {
            throw new IllegalArgumentException("Only suppports a single " + Deployable.class.getSimpleName());
        }
        return (Deployable)deployables.get(0);
    }

    protected final void configureLog4j() {
        String log4jProperties = this.getConfiguration().getPropertyValue(LOG4J_PROPERTIES);
        if (log4jProperties == null) {
            Logger root = Logger.getRootLogger();
            root.setLevel(Level.INFO);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        } else {
            PropertyConfigurator.configure((String)log4jProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        this.configureLog4j();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Deployable deployable = this.getDeployable();
            if (deployable instanceof MuleApplicationDeployable) {
                MuleApplicationDeployable muleApplicationDeployable = (MuleApplicationDeployable)deployable;
                URLClassLoader applicationClassLoader = URLClassLoader.newInstance(new URL[]{new File(muleApplicationDeployable.getFile()).toURI().toURL(), new URL("jar:file:" + muleApplicationDeployable.getFile() + "!/classes/")}, this.getClassLoader());
                Thread.currentThread().setContextClassLoader(applicationClassLoader);
                this.startServer(null);
            } else {
                MuleConfigurationDeployable muleConfigurationDeployable = (MuleConfigurationDeployable)deployable;
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                this.startServer(muleConfigurationDeployable.getFile());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected final void waitForCompletion(boolean waitForStarting) throws InterruptedException {
    }

    protected void doStop() throws Exception {
        this.getServer().getMuleContext().dispose();
    }
}

