/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.deployer;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableException;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.mule.tools.cargo.deployable.AbstractMuleDeployable;
import org.mule.tools.cargo.deployable.MuleApplicationDeployable;
import org.mule.tools.cargo.deployable.ZipApplicationDeployable;

public class FileDeployer
extends AbstractInstalledLocalDeployer {
    private static final long SLEEP_INTERVAL = 500L;
    private long maxFileWaitTime = 60000L;
    private static final long DEFAULT_MAX_FILE_WAIT_TIME = 60000L;
    private static final long DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000L;
    private static final String LOG_DEPLOY_CATEGORY = "mule3x:deploy";
    private static final String LOG_UNDEPLOY_CATEGORY = "mule3x:undeploy";

    public FileDeployer(InstalledLocalContainer container) {
        super((LocalContainer)container);
    }

    protected final void ensureMuleApplication(Deployable deployable) {
        if (!(deployable instanceof MuleApplicationDeployable) && !(deployable instanceof ZipApplicationDeployable)) {
            throw new DeployableException("Deployable type <" + deployable.getType() + "> is not supported!");
        }
    }

    protected InstalledLocalContainer getContainer() {
        return (InstalledLocalContainer)super.getContainer();
    }

    protected final File getAppsFolder() {
        return new File(this.getContainer().getHome() + "/apps");
    }

    protected final File getAnchorFile(AbstractMuleDeployable deployable) {
        return new File(this.getAppsFolder(), deployable.getApplicationName() + "-anchor.txt");
    }

    protected final File getApplicationFolder(AbstractMuleDeployable deployable) {
        return new File(this.getAppsFolder(), deployable.getApplicationName());
    }

    protected final String normalizeName(Deployable deployable) {
        String fileName = deployable.getFile();
        if (fileName.endsWith(".mule")) {
            return fileName.replace(".mule", ".zip");
        }
        return fileName;
    }

    protected final void waitForFile(File file, long timeout, boolean exist) throws DeployableException {
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < timeout) {
            if (file.exists() == exist) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        throw new DeployableException("Waited on <" + file + "> for <" + timeout + "> ms");
    }

    public void deploy(Deployable deployable) {
        this.ensureMuleApplication(deployable);
        AbstractMuleDeployable muleDeployable = (AbstractMuleDeployable)deployable;
        File appsFolder = this.getAppsFolder();
        File sourceFile = new File(deployable.getFile());
        File destinationFile = new File(appsFolder, sourceFile.getName());
        String applicationName = muleDeployable.getApplicationName();
        this.getLogger().info("Deploying <" + applicationName + ">", "deploy");
        this.getLogger().info("Copying <" + sourceFile + "> to <" + destinationFile + ">", LOG_DEPLOY_CATEGORY);
        try {
            FileUtils.getFileUtils().copyFile(sourceFile, destinationFile);
            File anchorFile = this.getAnchorFile(muleDeployable);
            this.getLogger().info("Waiting for <" + anchorFile + "> creation", LOG_DEPLOY_CATEGORY);
            long before = System.currentTimeMillis();
            this.waitForFile(anchorFile, this.maxFileWaitTime, true);
            this.getLogger().info("Deployed <" + applicationName + "> in <" + (System.currentTimeMillis() - before) + "> ms", LOG_DEPLOY_CATEGORY);
        }
        catch (IOException e) {
            this.getLogger().warn("Failed to copy application to <" + appsFolder + ">: " + e.toString(), LOG_DEPLOY_CATEGORY);
        }
    }

    public void undeploy(Deployable deployable) {
        this.ensureMuleApplication(deployable);
        AbstractMuleDeployable muleDeployable = (AbstractMuleDeployable)deployable;
        String applicationName = muleDeployable.getApplicationName();
        this.getLogger().info("Undeploying <" + applicationName + ">", LOG_UNDEPLOY_CATEGORY);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        File anchor = this.getAnchorFile(muleDeployable);
        if (anchor.exists()) {
            this.getLogger().info("Deleting <" + anchor + ">", LOG_UNDEPLOY_CATEGORY);
            if (!anchor.delete()) {
                throw new DeployableException("Failed to delete <" + anchor + ">");
            }
            File applicationFolder = this.getApplicationFolder(muleDeployable);
            this.getLogger().info("Waiting for <" + applicationFolder + "> deletion", LOG_UNDEPLOY_CATEGORY);
            long before = System.currentTimeMillis();
            this.waitForFile(applicationFolder, this.maxFileWaitTime, false);
            this.getLogger().info("Undeployed <" + applicationName + "> in <" + (System.currentTimeMillis() - before) + "> ms", LOG_UNDEPLOY_CATEGORY);
        } else {
            this.getLogger().info("No <" + anchor + "> to delete; skipping undeployment", LOG_UNDEPLOY_CATEGORY);
        }
    }
}

