/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Job;
import java.util.List;

public class JobWithDetails
extends Job {
    String displayName;
    boolean buildable;
    List<Build> builds;
    Build firstBuild;
    Build lastBuild;
    Build lastCompletedBuild;
    Build lastFailedBuild;
    Build lastStableBuild;
    Build lastSuccessfulBuild;
    Build lastUnstableBuild;
    Build lastUnsuccessfulBuild;
    int nextBuildNumber;
    List<Job> downstreamProjects;
    List<Job> upstreamProjects;

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public List<Build> getBuilds() {
        return Lists.transform(this.builds, (Function)new Function<Build, Build>(){

            public Build apply(Build from) {
                return JobWithDetails.this.buildWithClient(from);
            }
        });
    }

    private Build buildWithClient(Build from) {
        Build ret = from;
        if (from != null) {
            ret = new Build(from);
            ret.setClient(this.client);
        }
        return ret;
    }

    public Build getFirstBuild() {
        return this.firstBuild;
    }

    public Build getLastBuild() {
        return this.buildWithClient(this.lastBuild);
    }

    public Build getLastCompletedBuild() {
        return this.buildWithClient(this.lastCompletedBuild);
    }

    public Build getLastFailedBuild() {
        return this.buildWithClient(this.lastFailedBuild);
    }

    public Build getLastStableBuild() {
        return this.buildWithClient(this.lastStableBuild);
    }

    public Build getLastSuccessfulBuild() {
        return this.buildWithClient(this.lastSuccessfulBuild);
    }

    public Build getLastUnstableBuild() {
        return this.buildWithClient(this.lastUnstableBuild);
    }

    public Build getLastUnsuccessfulBuild() {
        return this.buildWithClient(this.lastUnsuccessfulBuild);
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public List<Job> getDownstreamProjects() {
        return Lists.transform(this.downstreamProjects, (Function)new JobWithClient());
    }

    public List<Job> getUpstreamProjects() {
        return Lists.transform(this.upstreamProjects, (Function)new JobWithClient());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobWithDetails that = (JobWithDetails)o;
        if (this.buildable != that.buildable) {
            return false;
        }
        if (this.nextBuildNumber != that.nextBuildNumber) {
            return false;
        }
        if (this.builds != null ? !this.builds.equals(that.builds) : that.builds != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.downstreamProjects != null ? !this.downstreamProjects.equals(that.downstreamProjects) : that.downstreamProjects != null) {
            return false;
        }
        if (this.lastBuild != null ? !this.lastBuild.equals(that.lastBuild) : that.lastBuild != null) {
            return false;
        }
        if (this.lastCompletedBuild != null ? !this.lastCompletedBuild.equals(that.lastCompletedBuild) : that.lastCompletedBuild != null) {
            return false;
        }
        if (this.lastFailedBuild != null ? !this.lastFailedBuild.equals(that.lastFailedBuild) : that.lastFailedBuild != null) {
            return false;
        }
        if (this.lastStableBuild != null ? !this.lastStableBuild.equals(that.lastStableBuild) : that.lastStableBuild != null) {
            return false;
        }
        if (this.lastSuccessfulBuild != null ? !this.lastSuccessfulBuild.equals(that.lastSuccessfulBuild) : that.lastSuccessfulBuild != null) {
            return false;
        }
        if (this.lastUnstableBuild != null ? !this.lastUnstableBuild.equals(that.lastUnstableBuild) : that.lastUnstableBuild != null) {
            return false;
        }
        if (this.lastUnsuccessfulBuild != null ? !this.lastUnsuccessfulBuild.equals(that.lastUnsuccessfulBuild) : that.lastUnsuccessfulBuild != null) {
            return false;
        }
        return !(this.upstreamProjects != null ? !this.upstreamProjects.equals(that.upstreamProjects) : that.upstreamProjects != null);
    }

    public Build getBuildByNumber(final int buildNumber) {
        Predicate<Build> isMatchingBuildNumber = new Predicate<Build>(){

            public boolean apply(Build input) {
                return input.getNumber() == buildNumber;
            }
        };
        Optional optionalBuild = Iterables.tryFind(this.builds, (Predicate)isMatchingBuildNumber);
        return optionalBuild.orNull() == null ? null : this.buildWithClient((Build)optionalBuild.orNull());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.buildable ? 1 : 0);
        result = 31 * result + (this.builds != null ? this.builds.hashCode() : 0);
        result = 31 * result + (this.lastBuild != null ? this.lastBuild.hashCode() : 0);
        result = 31 * result + (this.lastCompletedBuild != null ? this.lastCompletedBuild.hashCode() : 0);
        result = 31 * result + (this.lastFailedBuild != null ? this.lastFailedBuild.hashCode() : 0);
        result = 31 * result + (this.lastStableBuild != null ? this.lastStableBuild.hashCode() : 0);
        result = 31 * result + (this.lastSuccessfulBuild != null ? this.lastSuccessfulBuild.hashCode() : 0);
        result = 31 * result + (this.lastUnstableBuild != null ? this.lastUnstableBuild.hashCode() : 0);
        result = 31 * result + (this.lastUnsuccessfulBuild != null ? this.lastUnsuccessfulBuild.hashCode() : 0);
        result = 31 * result + this.nextBuildNumber;
        result = 31 * result + (this.downstreamProjects != null ? this.downstreamProjects.hashCode() : 0);
        result = 31 * result + (this.upstreamProjects != null ? this.upstreamProjects.hashCode() : 0);
        return result;
    }

    private class JobWithClient
    implements Function<Job, Job> {
        private JobWithClient() {
        }

        public Job apply(Job job) {
            job.setClient(JobWithDetails.this.client);
            return job;
        }
    }
}

