/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.offbytwo.jenkins.client.PreemptiveAuth;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.client.util.RequestReleasingInputStream;
import com.offbytwo.jenkins.client.validator.HttpResponseValidator;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.Crumb;
import com.offbytwo.jenkins.model.ExtractHeader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class JenkinsHttpClient {
    private static final int SO_TIMEOUT_IN_MILLISECONDS = 3000;
    private static final int CONNECTION_TIMEOUT_IN_MILLISECONDS = 500;
    private URI uri;
    private CloseableHttpClient client;
    private BasicHttpContext localContext;
    private HttpResponseValidator httpResponseValidator;
    private ObjectMapper mapper;
    private String context;

    public JenkinsHttpClient(URI uri, CloseableHttpClient client) {
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        this.client = client;
        this.httpResponseValidator = new HttpResponseValidator();
    }

    public JenkinsHttpClient(URI uri, HttpClientBuilder builder) {
        this(uri, builder.build());
    }

    public JenkinsHttpClient(URI uri) {
        this(uri, HttpClientBuilder.create());
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setIntParameter("http.socket.timeout", 3000);
        httpParams.setIntParameter("http.connection.timeout", 500);
        this.httpResponseValidator = new HttpResponseValidator();
    }

    public JenkinsHttpClient(URI uri, String username, String password) {
        this(uri, JenkinsHttpClient.addAuthentication(HttpClientBuilder.create(), uri, username, password));
        if (StringUtils.isNotBlank((String)username)) {
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T get(String path, Class<T> cls) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            T t = this.objectFromResponse(cls, (HttpResponse)response);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String path) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    public InputStream getFile(URI path) throws IOException {
        HttpGet getMethod = new HttpGet(path);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
        this.httpResponseValidator.validateResponse((HttpResponse)response);
        return new RequestReleasingInputStream(response.getEntity().getContent(), (HttpRequestBase)getMethod);
    }

    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls) throws IOException {
        return this.post(path, data, cls, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (data != null) {
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)stringEntity);
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            if (cls != null) {
                Object responseObject;
                if (cls.equals(ExtractHeader.class)) {
                    ExtractHeader location = new ExtractHeader();
                    location.setLocation(response.getFirstHeader("Location").getValue());
                    responseObject = location;
                } else {
                    responseObject = this.objectFromResponse(cls, (HttpResponse)response);
                }
                R r = responseObject;
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post_form(String path, Map<String, ?> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            ArrayList queryParams = Lists.newArrayList();
            for (String param : data.keySet()) {
                queryParams.add(param + "=" + EncodingUtils.encodeParam(JSONObject.fromObject(data.get(param)).toString()));
            }
            queryParams.add("json=" + EncodingUtils.encodeParam(JSONObject.fromObject(data).toString()));
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_FORM_URLENCODED);
            request = new HttpPost(this.noapi(path) + StringUtils.join((Collection)queryParams, (String)"&"));
            request.setEntity((HttpEntity)stringEntity);
        } else {
            request = new HttpPost(this.noapi(path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public String post_xml(String path, String xml_data) throws IOException {
        return this.post_xml(path, xml_data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_xml(String path, String xml_data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (xml_data != null) {
            request.setEntity((HttpEntity)new StringEntity(xml_data, ContentType.create((String)"text/xml", (String)"utf-8")));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        this.httpResponseValidator.validateResponse((HttpResponse)response);
        try {
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public String post_text(String path, String textData, boolean crumbFlag) throws IOException {
        return this.post_text(path, textData, ContentType.DEFAULT_TEXT, crumbFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_text(String path, String textData, ContentType contentType, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (textData != null) {
            request.setEntity((HttpEntity)new StringEntity(textData, contentType));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        this.httpResponseValidator.validateResponse((HttpResponse)response);
        try {
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public void post(String path) throws IOException {
        this.post(path, null, null, true);
    }

    public void post(String path, boolean crumbFlag) throws IOException {
        this.post(path, null, null, crumbFlag);
    }

    private String urlJoin(String path1, String path2) {
        if (!path1.endsWith("/")) {
            path1 = path1 + "/";
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        return path1 + path2;
    }

    private URI api(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        if (!path.contains("?")) {
            path = this.urlJoin(path, "api/json");
        } else {
            String[] components = path.split("\\?", 2);
            path = this.urlJoin(components[0], "api/json") + "?" + components[1];
        }
        return this.uri.resolve("/").resolve(path);
    }

    private URI noapi(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        return this.uri.resolve("/").resolve(path);
    }

    private <T extends BaseModel> T objectFromResponse(Class<T> cls, HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        byte[] bytes = ByteStreams.toByteArray((InputStream)content);
        String bytestring = new String(bytes);
        BaseModel result = (BaseModel)this.mapper.readValue(bytes, cls);
        result.setClient(this);
        return (T)result;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        httpRequestBase.releaseConnection();
    }

    private static HttpClientBuilder addAuthentication(HttpClientBuilder builder, URI uri, String username, String password) {
        if (StringUtils.isNotBlank((String)username)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(scope, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        }
        return builder;
    }
}

