/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.ComputerSet;
import com.offbytwo.jenkins.model.FolderJob;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobConfiguration;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.LabelWithDetails;
import com.offbytwo.jenkins.model.MainView;
import com.offbytwo.jenkins.model.MavenJobWithDetails;
import com.offbytwo.jenkins.model.QueueItem;
import com.offbytwo.jenkins.model.QueueReference;
import com.offbytwo.jenkins.model.View;
import com.offbytwo.jenkins.model.credential.Credential;
import com.offbytwo.jenkins.model.credential.GlobalCredentialsStore;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;
import org.dom4j.DocumentException;

public class JenkinsServer {
    private static final String CREDENTIALS_FORMAT = "%s %s credentials";
    private final JenkinsHttpClient client;

    public JenkinsServer(URI serverUri) {
        this(new JenkinsHttpClient(serverUri));
    }

    public JenkinsServer(URI serverUri, String username, String passwordOrToken) {
        this(new JenkinsHttpClient(serverUri, username, passwordOrToken));
    }

    public JenkinsServer(JenkinsHttpClient client) {
        this.client = client;
    }

    public boolean isRunning() {
        try {
            this.client.get("/");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Map<String, Job> getJobs() throws IOException {
        return this.getJobs(null, null);
    }

    public Map<String, Job> getJobs(FolderJob folder) throws IOException {
        return this.getJobs(folder, null);
    }

    public Map<String, Job> getJobs(String view) throws IOException {
        return this.getJobs(null, view);
    }

    public Map<String, Job> getJobs(FolderJob folder, String view) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        Class<MainView> viewClass = MainView.class;
        if (view != null) {
            path = path + "view/" + EncodingUtils.encode(view) + "/";
            viewClass = View.class;
        }
        List<Job> jobs = this.client.get(path, viewClass).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public Map<String, View> getViews() throws IOException {
        return this.getViews(null);
    }

    public Map<String, View> getViews(FolderJob folder) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        List<View> views = this.client.get(path, MainView.class).getViews();
        return Maps.uniqueIndex(views, (Function)new Function<View, String>(){

            public String apply(View view) {
                view.setClient(JenkinsServer.this.client);
                return view.getName();
            }
        });
    }

    public View getView(String name) throws IOException {
        return this.getView(null, name);
    }

    public View getView(FolderJob folder, String name) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        return this.client.get(path + "view/" + EncodingUtils.encode(name) + "/", View.class);
    }

    public JobWithDetails getJob(String jobName) throws IOException {
        return this.getJob(null, jobName);
    }

    public JobWithDetails getJob(FolderJob folder, String jobName) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        try {
            JobWithDetails job = this.client.get(path + "job/" + EncodingUtils.encode(jobName), JobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public MavenJobWithDetails getMavenJob(String jobName) throws IOException {
        return this.getMavenJob(null, jobName);
    }

    public MavenJobWithDetails getMavenJob(FolderJob folder, String jobName) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        try {
            MavenJobWithDetails job = this.client.get(path + "job/" + EncodingUtils.encode(jobName), MavenJobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public Optional<FolderJob> getFolderJob(Job job) throws IOException {
        try {
            FolderJob folder = this.client.get(job.getUrl(), FolderJob.class);
            if (!folder.isFolder()) {
                return Optional.absent();
            }
            folder.setClient(this.client);
            return Optional.of((Object)folder);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void createJob(String jobName, String jobXml) throws IOException {
        this.createJob(null, jobName, jobXml, true);
    }

    public void createJob(String jobName, String jobXml, Boolean crumbFlag) throws IOException {
        this.createJob(null, jobName, jobXml, crumbFlag);
    }

    public void createJob(FolderJob folder, String jobName, String jobXml) throws IOException {
        this.createJob(folder, jobName, jobXml, true);
    }

    public void createJob(FolderJob folder, String jobName, String jobXml, Boolean crumbFlag) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        this.client.post_xml(path + "createItem?name=" + EncodingUtils.encodeParam(jobName), jobXml, crumbFlag);
    }

    public void createFolder(String jobName) throws IOException {
        this.createFolder(null, jobName, false);
    }

    public void createFolder(String jobName, Boolean crumbFlag) throws IOException {
        this.createFolder(null, jobName, crumbFlag);
    }

    public void createFolder(FolderJob folder, String jobName) throws IOException {
        this.createFolder(folder, jobName, false);
    }

    public void createFolder(FolderJob folder, String jobName, Boolean crumbFlag) throws IOException {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        ImmutableMap params = ImmutableMap.of((Object)"mode", (Object)"com.cloudbees.hudson.plugins.folder.Folder", (Object)"name", (Object)EncodingUtils.encodeParam(jobName), (Object)"from", (Object)"", (Object)"Submit", (Object)"OK");
        this.client.post_form(path + "createItem?", (Map<String, ?>)params, crumbFlag);
    }

    public String getJobXml(String jobName) throws IOException {
        return this.client.get("/job/" + EncodingUtils.encode(jobName) + "/config.xml");
    }

    public LabelWithDetails getLabel(String labelName) throws IOException {
        return this.client.get("/label/" + EncodingUtils.encode(labelName), LabelWithDetails.class);
    }

    public Map<String, Computer> getComputers() throws IOException {
        List<Computer> computers = this.client.get("computer/", Computer.class).getComputers();
        return Maps.uniqueIndex(computers, (Function)new Function<Computer, String>(){

            public String apply(Computer computer) {
                computer.setClient(JenkinsServer.this.client);
                return computer.getDisplayName().toLowerCase();
            }
        });
    }

    public ComputerSet getComputerSet() throws IOException {
        return this.client.get("computer/", ComputerSet.class);
    }

    public void updateJob(String jobName, String jobXml) throws IOException {
        this.updateJob(jobName, jobXml, true);
    }

    public void updateJob(String jobName, String jobXml, boolean crumbFlag) throws IOException {
        this.client.post_xml("/job/" + EncodingUtils.encode(jobName) + "/config.xml", jobXml, crumbFlag);
    }

    public void addStringParam(String jobName, String name, String description, String defaultValue) throws IOException, JAXBException, DocumentException {
        String jobXml = this.getJobXml(jobName);
        JobConfiguration jobConf = new JobConfiguration(jobXml);
        jobXml = jobConf.addStringParam(name, description, defaultValue).asXml();
        this.updateJob(jobName, jobXml);
    }

    public void createCredentials(String username, String password, String host) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"scope", (Object)"GLOBAL");
        builder.put((Object)"username", (Object)username);
        builder.put((Object)"password", (Object)password);
        builder.put((Object)"description", (Object)String.format(CREDENTIALS_FORMAT, username, host));
        builder.put((Object)"id", (Object)"");
        builder.put((Object)"stapler-class", (Object)"com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl");
        builder.put((Object)"$class", (Object)"com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl");
        ImmutableMap params = ImmutableMap.of((Object)"credentials", (Object)builder.build());
        this.client.post_form("/credentials/store/system/domain/_/createCredentials?", (Map<String, ?>)params, true);
    }

    public GlobalCredentialsStore getCredentials() throws IOException {
        return this.client.get("/credentials/store/system/domain/_?depth=1", GlobalCredentialsStore.class);
    }

    public String getCredentialId(String username, String host) throws IOException {
        GlobalCredentialsStore credentialsStore = this.getCredentials();
        String description = String.format(CREDENTIALS_FORMAT, username, host);
        for (Credential credential : credentialsStore.getCredentials()) {
            if (!credential.getDescription().matches(description)) continue;
            return credential.getId();
        }
        return null;
    }

    public void deleteCredentials(String credentialsId) throws IOException {
        this.client.post("/credentials/store/system/domain/_/credential/" + credentialsId + "/doDelete");
    }

    public void quietDown() throws IOException {
        try {
            this.client.get("/quietDown/");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
    }

    public void cancelQuietDown() throws IOException {
        try {
            this.client.post("/cancelQuietDown/");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
    }

    public void deleteJob(String jobName) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/doDelete");
    }

    public void deleteJob(String jobName, boolean crumbFlag) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/doDelete", crumbFlag);
    }

    public void addJobToView(String jobName, String viewName, boolean crumbflag) throws IOException {
        this.client.post("/view/" + EncodingUtils.encode(viewName) + "/addJobToView?name=" + EncodingUtils.encode(jobName), crumbflag);
    }

    public String runScript(String script) throws IOException {
        return this.client.post_text("/scriptText", "script=" + script, ContentType.APPLICATION_FORM_URLENCODED, false);
    }

    public QueueItem getQueueItem(QueueReference ref) throws IOException {
        try {
            String url = ref.getQueueItemUrlPart();
            QueueItem job = this.client.get(url, QueueItem.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public Build getBuild(QueueItem q) throws IOException {
        try {
            String url = q.getExecutable().getUrl();
            Build job = this.client.get(url, Build.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }
}

