/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.model.Job;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FolderJob
extends Job {
    String displayName;
    List<Job> jobs;

    public FolderJob() {
    }

    public FolderJob(String name, String url) {
        super(name, url);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isFolder() {
        return this.jobs != null;
    }

    public Map<String, Job> getJobs() {
        return Maps.uniqueIndex(this.jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(FolderJob.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public Job getJob(String name) {
        return (Job)Maps.uniqueIndex(this.jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(FolderJob.this.client);
                return job.getName().toLowerCase();
            }
        }).get((Object)name);
    }

    public void createFolder(String jobName) throws IOException {
        this.createFolder(jobName, false);
    }

    public void createFolder(String jobName, Boolean crumbFlag) throws IOException {
        ImmutableMap params = ImmutableMap.of((Object)"mode", (Object)"com.cloudbees.hudson.plugins.folder.Folder", (Object)"name", (Object)EncodingUtils.encodeParam(jobName), (Object)"from", (Object)"", (Object)"Submit", (Object)"OK");
        this.client.post_form(this.getUrl() + "/createItem?", (Map<String, ?>)params, crumbFlag);
    }
}

