package org.mule.tools.connectivity.jenkins.client.models.properties;

public class JobBlocker implements JenkinsProperty {

    private final String jobNameRegex;

    public JobBlocker(String jobNameRegex) {
        this.jobNameRegex = jobNameRegex;
    }

    @Override
    public String getXmlConfig() {
        return "<hudson.plugins.buildblocker.BuildBlockerProperty plugin=\"build-blocker-plugin@1.7.1\">\n" +
                "      <useBuildBlocker>true</useBuildBlocker>\n" +
                "      <blockLevel>GLOBAL</blockLevel>\n" +
                "      <scanQueueFor>DISABLED</scanQueueFor>\n" +
                "      <blockingJobs>" + jobNameRegex + "</blockingJobs>\n" +
                "    </hudson.plugins.buildblocker.BuildBlockerProperty>";
    }
}
