package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.codec.binary.Base64;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class CredentialsStep implements JenkinsStep {

    private String folderPath;
    private String name;
    private String destinyLocation;

    public CredentialsStep(String folderPath, String name, String destinyLocation){
        this.folderPath = folderPath;
        this.name = name;
        this.destinyLocation = destinyLocation;
    }

    @Override public String getXmlConfig() {
        return new ShellStep(createCredentialsShellStep(name,destinyLocation)).getXmlConfig();
    }

    public String createCredentialsShellStep(String fileLocation, String overridedLocation) {

        String location = "src/test/resources/";
        String[] split = fileLocation.split("/");
        String fileName = split[split.length - 1];

        if (overridedLocation != null) {
            location = overridedLocation;
        }

        String encodedFile;
        try {
            encodedFile = encodeFileToBase64Binary(new File(folderPath+fileLocation));
        } catch (IOException e) {
            throw new RuntimeException("Failed to retrieve configuration file", e);
        }
        return "echo \"" + encodedFile + "\" | base64 --decode > " + location + fileName;
    }

    private static String encodeFileToBase64Binary(File file) throws IOException {
        String encodedFile;
        FileInputStream fileInputStreamReader = new FileInputStream(file);
        byte[] bytes = new byte[(int) file.length()];
        fileInputStreamReader.read(bytes);
        encodedFile = Base64.encodeBase64String(bytes);

        return encodedFile;
    }
}
