package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PropertiesFileStep implements JenkinsStep {

    public static final String DEFAULT_FILE_LOCATION = "src/test/resources/";
    public static final String DEFAULT_FILE_NAME = "automation-credentials.properties";

    private byte[] contents;
    private String location;
    private String name;

    public PropertiesFileStep(String fileContents) {
        this.contents = fileContents.getBytes();
        this.location = DEFAULT_FILE_LOCATION;
        this.name = DEFAULT_FILE_NAME;
    }

    public PropertiesFileStep(InputStream fileContents) throws IOException {
        this.contents = IOUtils.toByteArray(fileContents);
        this.location = DEFAULT_FILE_LOCATION;
        this.name = DEFAULT_FILE_NAME;
    }

    @Override
    public String getXmlConfig() {
        String shellFormat = "echo \"%s\" | base64 --decode > %s";
        Path outputPath = Paths.get(location, name);
        String base64Contents = Base64.encodeBase64String(this.contents);

        String shellCommand = String.format(shellFormat, base64Contents, outputPath.toString());
        return new ShellStep(shellCommand).getXmlConfig();
    }

}
