package org.mule.tools.connectivity.jenkins.client.retrievers;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class WebDavMuleVersionsRetriever extends MuleVersionRetriever{

    String user;
    String password;
    List<String> muleList;

    private static WebDavMuleVersionsRetriever instance = null;

    private String webdavUrl = "https://repository-mule-connectors.forge.cloudbees.com/private/mules/";

    public static WebDavMuleVersionsRetriever getInstance(String user, String password) {
        if (instance == null) {
            instance = new WebDavMuleVersionsRetriever(user, password);
        }
        return instance;
    }

    public WebDavMuleVersionsRetriever(String user, String password){
        this.user = user;
        this.password = password;
    }

    public List<String> getEEMuleList() {
        return getMuleList().stream()
                .filter(mule -> mule.toLowerCase().contains("enterprise"))
                .collect(Collectors.toList());
    }

    public List<String> getEEMuleList(String muleMinVersion) {
        return getEEMuleList().stream()
                .filter(mule -> isValidMuleVersion(muleMinVersion, mule.split("-")[3]))
                .collect(Collectors.toList());
    }

    public List<String> getCEMuleList() {
        return getMuleList().stream()
                .filter(mule -> !mule.toLowerCase().contains("enterprise"))
                .collect(Collectors.toList());
    }

    public List<String> getCEMuleList(String muleMinVersion) {
        return getCEMuleList().stream()
                .filter(mule -> isValidMuleVersion(muleMinVersion, mule.split("-")[2]))
                .collect(Collectors.toList());
    }

    public List<String> getMuleList() {
        if (muleList == null) {
            Sardine sardine = SardineFactory.begin(user, password);

            List<DavResource> resources = null;
            try {
                resources = sardine.getResources(webdavUrl);
                sardine.shutdown();
            } catch (IOException e) {
                throw new RuntimeException("Problem retrieving mule versions. Please check your credentials and ensure that are correct.");
            }


            muleList =  resources.stream()
                    .filter(res -> res.getName().endsWith(".zip") && !res.getName().startsWith("._"))
                    .filter(res -> !res.getName().contains("mule-enterprise-standalone-3.8.0-SNAPSHOT.zip"))
                    .map(res -> res.getName().substring(0, res.getName().length() - 4))
                    .collect(Collectors.toList());
            return muleList;
        } else {
//            System.out.println("Using already existen");
            return muleList;
        }
    }



    public String getWebdavUrl() {
        return webdavUrl;
    }

    public void setWebdavUrl(String webdavUrl) {
        this.webdavUrl = webdavUrl;
    }
}
