package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;

import java.util.HashMap;
import java.util.Map;

import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.cloudHubBuildStep;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.ctfBuildStep;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.getEnableJceSteps;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.getUpdateMuleConfForJceEnabledJavaSteps;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.unzipMuleStandaloneStep;

public class MultiMuleXmlConfigBuilder extends BasicXmlConfigBuilder{

    private static final String CLEAN_PACKAGE_DSKIP_TESTS_GOAL = "clean package -DskipTests";

    MuleVersionRetriever muleVersionRetriever;

    public MultiMuleXmlConfigBuilder(final MuleVersionRetriever muleVersionRetriever){
        this.muleVersionRetriever = muleVersionRetriever;
    }

    public String buildXmlConfig(final ConnectorConfiguration connector, final String branch) {

        String xml = getResourceAsString(BASIC_TEMPLATE_XML);

        String hackStep = StringUtils.EMPTY;
        if (!connector.getHackStep().equals(StringUtils.EMPTY)) {
            hackStep = new ShellStep(connector.getHackStep()).getXmlConfig();
        }

        Map<String, String> valuesMap = new HashMap<>();

        String cloudHubConfig = "";

        if(connector.getCloudHubEnabled() && branch.contains(DEVELOP_BRANCH)){
            cloudHubConfig = cloudHubBuildStep(connector).getXmlConfig();
        }

        valuesMap.put(GITHUB_CONFIG, connector.getGitHubConfig(branch).getXmlConfig());
        valuesMap.put(GITHUB_HTTP_URL, GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put(UNZIP_MULE_SHELL_STEP, unzipMulesSteps(connector) + hackStep);
        valuesMap.put(CONNECTOR_STEPS, connector.getSteps());
        valuesMap.put(CTF_BUILD_STEP, ctfBuildSteps(connector, branch) + cloudHubConfig);
        valuesMap.put(MAILER, connector.getMailer().getXmlConfig());
        valuesMap.put(TRIGGER, new TimeTrigger(branch.contains(DEVELOP_BRANCH) ? EVERY_SUNDAY : EVERY_15_DAYS).getXmlConfig());
        valuesMap.put(JDK_VERSION, connector.getJceEnabled() ? JDK_1_7_JCE : JDK_1_7);
        valuesMap.put(ENABLE_JCE_STEPS, connector.getJceEnabled() ? getEnableJceSteps().getXmlConfig() : StringUtils.EMPTY);
        valuesMap.put(MULE_CONF_FOR_JCE_STEPS, connector.getJceEnabled() ? getUpdateMuleConfForJceEnabledJavaSteps().getXmlConfig() : StringUtils.EMPTY);
        valuesMap.put(PROPERTIES, connector.getParallelBuilds() ? StringUtils.EMPTY : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put(BUILD_WRAPPERS, "");
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

    private String unzipMulesSteps(final ConnectorConfiguration connector) {
        String steps = StringUtils.EMPTY;
        for (String muleVersion : muleVersionRetriever.getEEMuleList(connector.getMinMuleVersion())) {
            steps = steps.concat(unzipMuleStandaloneStep(muleVersion).getXmlConfig());
        }
        if (!connector.getIsEnterprise()) {
            for (String muleVersion : muleVersionRetriever.getCEMuleList(connector.getMinMuleVersion())) {
                steps = steps.concat(unzipMuleStandaloneStep(muleVersion).getXmlConfig());
            }
        }
        return steps;
    }

    private String ctfBuildSteps(final ConnectorConfiguration connector, String branch) {
        String steps = new MavenStep(CLEAN_PACKAGE_DSKIP_TESTS_GOAL).getXmlConfig();
        for (String muleVersion : muleVersionRetriever.getEEMuleList(connector.getMinMuleVersion())) {
            steps = steps.concat(ctfBuildStep(connector, muleVersion, branch).getXmlConfig());
        }
        if (!connector.getIsEnterprise()) {
            for (String muleVersion : muleVersionRetriever.getCEMuleList(connector.getMinMuleVersion())) {
                steps = steps.concat(ctfBuildStep(connector, muleVersion, branch).getXmlConfig());
            }
        }

        return steps;
    }

}
