/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client;

import java.util.LinkedList;
import java.util.List;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.publishers.Mailer;
import org.mule.tools.connectivity.jenkins.client.models.scm.GithubSCM;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;

public class ConnectorConfiguration {
    String category;
    Boolean isEnterprise;
    Boolean masterSupport;
    Boolean developSupport;
    Boolean developClassicSupport;
    Boolean masterClassicSupport;
    String minMuleVersion;
    String name;
    String gitHubUrl;
    String credentialUrl;
    String properties;
    List<JenkinsModel> buildSteps;
    String testingConfiguration;
    String testingConfigurationForMaster;
    GithubSCM githubConfig;
    Mailer mailer;
    String overrideMuleLocation;
    String hackStep;
    List<String> activeConfigs;
    Boolean jceEnabled;
    Boolean cloudHubEnabled;
    Boolean parallelBuilds;
    String jvmOptions;

    public ConnectorConfiguration(String name) {
        this.name = name;
        this.githubConfig = new GithubSCM();
        this.buildSteps = new LinkedList<JenkinsModel>();
        this.mailer = new Mailer();
        this.setIsEnterprise(Boolean.FALSE);
        this.setMasterSupport(Boolean.FALSE);
        this.setDevelopSupport(Boolean.FALSE);
        this.setMinMuleVersion("3.5.0");
        this.overrideMuleLocation = "";
        this.setJceEnabled(Boolean.FALSE);
        this.setCloudHubEnabled(Boolean.FALSE);
        this.setParallelBuilds(Boolean.FALSE);
    }

    public Boolean getParallelBuilds() {
        return this.parallelBuilds;
    }

    public void setParallelBuilds(Boolean parallelBuilds) {
        this.parallelBuilds = parallelBuilds;
    }

    public List<String> getActiveConfigs() {
        return this.activeConfigs;
    }

    public Boolean getCloudHubEnabled() {
        return this.cloudHubEnabled;
    }

    public void setCloudHubEnabled(Boolean cloudHubEnabled) {
        this.cloudHubEnabled = cloudHubEnabled;
    }

    public void setActiveConfigs(List<String> activeConfigs) {
        this.activeConfigs = activeConfigs;
    }

    public String getHackStep() {
        return this.hackStep;
    }

    public void setHackStep(String hackStep) {
        this.hackStep = hackStep;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public void setMinMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public Boolean getDevelopClassicSupport() {
        return this.developClassicSupport;
    }

    public void setDevelopClassicSupport(Boolean developClassicSupport) {
        this.developClassicSupport = developClassicSupport;
    }

    public Boolean getMasterClassicSupport() {
        return this.masterClassicSupport;
    }

    public void setMasterClassicSupport(Boolean masterClassicSupport) {
        this.masterClassicSupport = masterClassicSupport;
    }

    public String getOverrideMuleLocation() {
        return this.overrideMuleLocation;
    }

    public void setOverrideMuleLocation(String overrideMuleLocation) {
        this.overrideMuleLocation = overrideMuleLocation;
    }

    public Boolean getDevelopSupport() {
        return this.developSupport;
    }

    public void setDevelopSupport(Boolean developSupport) {
        this.developSupport = developSupport;
    }

    public Boolean getMasterSupport() {
        return this.masterSupport;
    }

    public void setMasterSupport(Boolean masterSupport) {
        this.masterSupport = masterSupport;
    }

    public String getGitHubUrl() {
        return this.gitHubUrl;
    }

    public void setGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    public String getCredentialUrl() {
        return this.credentialUrl;
    }

    public void setCredentialUrl(String credentialUrl) {
        this.credentialUrl = credentialUrl;
    }

    public void setMailer(String emails) {
        this.mailer.setMails(emails);
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    public Boolean getJceEnabled() {
        return this.jceEnabled;
    }

    public void setJceEnabled(Boolean jceEnabled) {
        this.jceEnabled = jceEnabled;
    }

    public Boolean getIsEnterprise() {
        return this.isEnterprise;
    }

    public void setIsEnterprise(Boolean isEnterprise) {
        this.isEnterprise = isEnterprise;
    }

    public List<JenkinsModel> getBuildSteps() {
        return this.buildSteps;
    }

    public String getTestingConfiguration() {
        return this.testingConfiguration;
    }

    public void setTestingConfiguration(String testingConfiguration) {
        this.testingConfiguration = testingConfiguration;
    }

    public String getTestingConfigurationForMaster() {
        return this.testingConfigurationForMaster;
    }

    public void setTestingConfigurationForMaster(String testingConfigurationForMaster) {
        this.testingConfigurationForMaster = testingConfigurationForMaster;
    }

    public void addShellStep(String step) {
        this.buildSteps.add(new ShellStep(step));
    }

    public void addShellStep(ShellStep step) {
        this.buildSteps.add(step);
    }

    public void addMavenStep(String step) {
        this.buildSteps.add(new MavenStep(step));
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getSteps() {
        return this.getCompleteSteps(this.buildSteps);
    }

    private String getCompleteSteps(List<JenkinsModel> steps) {
        String completeSteps = "";
        for (JenkinsModel step : steps) {
            completeSteps = completeSteps.concat(step.getXmlConfig()).concat("\n");
        }
        return completeSteps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addGitHubConfig(String gitUrl) {
        this.gitHubUrl = gitUrl;
        this.githubConfig.setGitHubUrl(gitUrl);
    }

    public GithubSCM getGitHubConfig(String branch) {
        this.githubConfig.setGitHubBranch(branch);
        return this.githubConfig;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }
}

