/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.models.step;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;

public class CredentialsStep
implements JenkinsStep {
    private String folderPath;
    private String name;
    private String destinyLocation;

    public CredentialsStep(String folderPath, String name, String destinyLocation) {
        this.folderPath = folderPath;
        this.name = name;
        this.destinyLocation = destinyLocation;
    }

    @Override
    public String getXmlConfig() {
        return new ShellStep(this.createCredentialsShellStep(this.name, this.destinyLocation)).getXmlConfig();
    }

    public String createCredentialsShellStep(String fileLocation, String overridedLocation) {
        String encodedFile;
        String location = "src/test/resources/";
        String[] split = fileLocation.split("/");
        String fileName = split[split.length - 1];
        if (overridedLocation != null) {
            location = overridedLocation;
        }
        try {
            encodedFile = CredentialsStep.encodeFileToBase64Binary(new File(this.folderPath + fileLocation));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve configuration file", e);
        }
        return "echo \"" + encodedFile + "\" | base64 --decode > " + location + fileName;
    }

    private static String encodeFileToBase64Binary(File file) throws IOException {
        FileInputStream fileInputStreamReader = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        fileInputStreamReader.read(bytes);
        String encodedFile = Base64.encodeBase64String((byte[])bytes);
        return encodedFile;
    }
}

