package org.mule.tools.connectivity.jenkins.client.models.properties;

public class SecurityGroupProperty implements JenkinsProperty {

    public static final String DEFAULT_ROLE = "reader";

    private String memberName;
    private String groupName;
    private String role;

    public SecurityGroupProperty(String memberName, String groupName) {
        this.memberName = memberName;
        this.groupName = groupName;
        this.role = DEFAULT_ROLE;
    }

    public SecurityGroupProperty(String memberName, String groupName, String role) {
        this.memberName = memberName;
        this.groupName = groupName;
        this.role = role;
    }

    @Override
    public String getXmlConfig() {
        return "<nectar.plugins.rbac.groups.JobProxyGroupContainer plugin=\"nectar-rbac@4.16\">\n"
                + "      <groups>\n"
                + "        <nectar.plugins.rbac.groups.Group>\n"
                + "          <name>" + groupName + "</name>\n"
                + "          <member>" + memberName + "</member>\n"
                + "          <role>" + role + "</role>\n"
                + "        </nectar.plugins.rbac.groups.Group>\n"
                + "      </groups>\n"
                + "    </nectar.plugins.rbac.groups.JobProxyGroupContainer>";
    }

}
