package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * Created by estebanwasinger on 6/25/15.
 */
public class ShellStep implements JenkinsStep {

    String shellCommand;

    public ShellStep(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    @Override
    public String getXmlConfig() {
        return "    <hudson.tasks.Shell>\n" +
                "      <command>" + StringEscapeUtils.escapeXml(shellCommand) + "</command>\n" +
                "    </hudson.tasks.Shell>";
    }

    @Override
    public String toString() {
        return shellCommand;
    }

}
