package org.mule.tools.connectivity.jenkins.client.models.triggers;

public class PullRequestBuilderTrigger implements JenkinsTrigger {

    private static final String GITHUB_AUTH_ID = "4e91f0f0-3e16-4d71-b822-e93d74f4c450";
    private static final String STARTED_STATUS = "Pull Request Build Started - $BUILD_URL";
    private static final String TRIGGERED_STATUS = "Pull Request Build Triggered";
    private static final String COMMIT_STATUS_CONTEXT = "Jenkins CI";
    private String projectName;

    public PullRequestBuilderTrigger(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getXmlConfig() {
        return "<org.jenkinsci.plugins.ghprb.GhprbTrigger plugin=\"ghprb@1.26.2\">\n" +
                "      <spec>H/5 * * * *</spec>\n" +
                "      <configVersion>1</configVersion>\n" +
                "      <adminlist></adminlist>\n" +
                "      <allowMembersOfWhitelistedOrgsAsAdmin>false</allowMembersOfWhitelistedOrgsAsAdmin>\n" +
                "      <orgslist></orgslist>\n" +
                "      <cron>H/5 * * * *</cron>\n" +
                "      <triggerPhrase>build</triggerPhrase>\n" +
                "      <buildDescTemplate></buildDescTemplate>\n" +
                "      <onlyTriggerPhrase>false</onlyTriggerPhrase>\n" +
                "      <useGitHubHooks>true</useGitHubHooks>\n" +
                "      <permitAll>true</permitAll>\n" +
                "      <whitelist></whitelist>\n" +
                "      <autoCloseFailedPullRequests>false</autoCloseFailedPullRequests>\n" +
                "      <displayBuildErrorsOnDownstreamBuilds>false</displayBuildErrorsOnDownstreamBuilds>\n" +
                "      <whiteListTargetBranches>\n" +
                "        <org.jenkinsci.plugins.ghprb.GhprbBranch>\n" +
                "          <branch></branch>\n" +
                "        </org.jenkinsci.plugins.ghprb.GhprbBranch>\n" +
                "      </whiteListTargetBranches>\n" +
                "      <project>" + projectName + "</project>\n" +
                "      <__project class=\"project\" reference=\"../../..\"/>\n" +
                "      <gitHubAuthId>" + GITHUB_AUTH_ID + "</gitHubAuthId>\n" +
                "      <extensions>\n" +
                "        <org.jenkinsci.plugins.ghprb.extensions.status.GhprbSimpleStatus>\n" +
                "          <commitStatusContext>" + COMMIT_STATUS_CONTEXT + "</commitStatusContext>\n" +
                "          <triggeredStatus>" + TRIGGERED_STATUS + "</triggeredStatus>\n" +
                "          <startedStatus>" + STARTED_STATUS + "</startedStatus>\n" +
                "          <statusUrl></statusUrl>\n" +
                "        </org.jenkinsci.plugins.ghprb.extensions.status.GhprbSimpleStatus>\n" +
                "      </extensions>\n" +
                "    </org.jenkinsci.plugins.ghprb.GhprbTrigger>";
    }
}
