package org.mule.tools.connectivity.jenkins.client.retrievers;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

import java.util.List;

public abstract class MuleVersionRetriever {

    public List<String> getEEMuleList() {
        throw new UnsupportedOperationException();
    }

    public List<String> getEEMuleList(String muleMinVersion) {
        throw new UnsupportedOperationException();
    }

    public List<String> getCEMuleList(){
        throw new UnsupportedOperationException();
    }

    public List<String> getCEMuleList(String muleMinVersion){
        throw new UnsupportedOperationException();
    }

    Boolean isValidMuleVersion(String minMuleVersion, String muleVersion) {
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion(minMuleVersion);
        DefaultArtifactVersion actualVersion = new DefaultArtifactVersion(muleVersion);
        if (actualVersion.compareTo(minVersion) == 0 || actualVersion.compareTo(minVersion) == 1) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }
}
