package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.BuildWrapper;
import org.mule.tools.connectivity.jenkins.client.models.properties.JenkinsProperty;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JenkinsPublisher;
import org.mule.tools.connectivity.jenkins.client.models.scm.GithubSCM;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.JenkinsTrigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JenkinsConfigBuilder extends BasicXmlConfigBuilder {

    private String jdkVersion = JDK_1_7;
    private JenkinsModel githubConfig;
    private List<JenkinsModel> stepsList = new ArrayList<>();
    private List<JenkinsModel> propertiesList = new ArrayList<>();
    private List<JenkinsModel> triggersList = new ArrayList<>();
    private List<JenkinsModel> publisherList = new ArrayList<>();
    private List<JenkinsModel> wrapperList = new ArrayList<>();

    private JenkinsConfigBuilder() {
    }

    public static JenkinsConfigBuilder getJobXml(GithubSCM githubConfig) {
        JenkinsConfigBuilder jenkinsConfigBuilder = new JenkinsConfigBuilder();
        jenkinsConfigBuilder.githubConfig = githubConfig;
        return jenkinsConfigBuilder;
    }

    public JenkinsConfigBuilder withStep(JenkinsStep step) {
        this.stepsList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withProperty(JenkinsProperty step) {
        this.propertiesList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withTrigger(JenkinsTrigger step) {
        this.triggersList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withPublisher(JenkinsPublisher step) {
        this.publisherList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withJdkVersion(String jdkVersion) {
        this.jdkVersion = jdkVersion;
        return this;
    }

    public JenkinsConfigBuilder withBuildWrapper(BuildWrapper step) {
        this.wrapperList.add(step);
        return this;
    }

    public String build() {
        String xml = getResourceAsString(BYOC_BASIC_TEMPLATE_XML);

        Map<String, String> valuesMap = new HashMap<>();
        valuesMap.put("JDK_VERSION", jdkVersion);
        valuesMap.put("GITHUB_CONFIG", githubConfig.getXmlConfig());
        valuesMap.put("TRIGGERS", getXmlFromModelList(triggersList));
        valuesMap.put("PUBLISHERS", getXmlFromModelList(publisherList));
        valuesMap.put("BUILDERS", getXmlFromModelList(stepsList));
        valuesMap.put("PROPERTIES", getXmlFromModelList(propertiesList));
        valuesMap.put("BUILD_WRAPPERS", getXmlFromModelList(wrapperList));

        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

    private String getXmlFromModelList(List<JenkinsModel> modelList) {
        String config = "";

        for (JenkinsModel jenkinsModel : modelList) {
            config = config.concat(jenkinsModel.getXmlConfig());
        }

        return config;
    }
}

