/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.retrievers;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;

public class WebDavMuleVersionsRetriever
extends MuleVersionRetriever {
    String user;
    String password;
    List<String> muleList;
    private static WebDavMuleVersionsRetriever instance = null;
    private String webdavUrl = "https://repository-mule-connectors.forge.cloudbees.com/private/mules/";

    public static WebDavMuleVersionsRetriever getInstance(String user, String password) {
        if (instance == null) {
            instance = new WebDavMuleVersionsRetriever(user, password);
        }
        return instance;
    }

    public WebDavMuleVersionsRetriever(String user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public List<String> getEEMuleList() {
        return this.getMuleList().stream().filter(mule -> mule.toLowerCase().contains("enterprise")).collect(Collectors.toList());
    }

    @Override
    public List<String> getEEMuleList(String muleMinVersion) {
        return this.getEEMuleList().stream().filter(mule -> this.isValidMuleVersion(muleMinVersion, mule.split("-")[3])).collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMuleList() {
        return this.getMuleList().stream().filter(mule -> !mule.toLowerCase().contains("enterprise")).collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMuleList(String muleMinVersion) {
        return this.getCEMuleList().stream().filter(mule -> this.isValidMuleVersion(muleMinVersion, mule.split("-")[2])).collect(Collectors.toList());
    }

    public List<String> getMuleList() {
        if (this.muleList == null) {
            Sardine sardine = SardineFactory.begin((String)this.user, (String)this.password);
            List resources = null;
            try {
                resources = sardine.getResources(this.webdavUrl);
                sardine.shutdown();
            }
            catch (IOException e) {
                throw new RuntimeException("Problem retrieving mule versions. Please check your credentials and ensure that are correct.");
            }
            this.muleList = resources.stream().filter(res -> res.getName().endsWith(".zip") && !res.getName().startsWith("._")).map(res -> res.getName().substring(0, res.getName().length() - 4)).collect(Collectors.toList());
            return this.muleList;
        }
        return this.muleList;
    }

    public String getWebdavUrl() {
        return this.webdavUrl;
    }

    public void setWebdavUrl(String webdavUrl) {
        this.webdavUrl = webdavUrl;
    }
}

