/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class MultiMuleXmlConfigBuilder
extends BasicXmlConfigBuilder {
    private static final String CLEAN_PACKAGE_DSKIP_TESTS_GOAL = "clean package -DskipTests";
    MuleVersionRetriever muleVersionRetriever;

    public MultiMuleXmlConfigBuilder(MuleVersionRetriever muleVersionRetriever) {
        this.muleVersionRetriever = muleVersionRetriever;
    }

    public String buildXmlConfig(ConnectorConfiguration connector, String branch) {
        String xml = MultiMuleXmlConfigBuilder.getResourceAsString("basic-template.xml");
        String hackStep = "";
        if (!connector.getHackStep().equals("")) {
            hackStep = new ShellStep(connector.getHackStep()).getXmlConfig();
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        String cloudHubConfig = "";
        if (connector.getCloudHubEnabled().booleanValue() && branch.contains("develop")) {
            cloudHubConfig = StepBuilder.cloudHubBuildStep(connector).getXmlConfig();
        }
        valuesMap.put("githubConfig", connector.getGitHubConfig(branch).getXmlConfig());
        valuesMap.put("GITHUB_HTTP_URL", GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put("unzipMuleShellStep", this.unzipMulesSteps(connector) + hackStep);
        valuesMap.put("connectorSteps", connector.getSteps());
        valuesMap.put("ctfBuildStep", this.ctfBuildSteps(connector, branch) + cloudHubConfig);
        valuesMap.put("mailer", connector.getMailer().getXmlConfig());
        valuesMap.put("trigger", new TimeTrigger(branch.contains("develop") ? EVERY_SUNDAY : EVERY_15_DAYS).getXmlConfig());
        valuesMap.put("jdkVersion", connector.getJceEnabled() != false ? JDK_1_7_JCE : JDK_1_7);
        valuesMap.put("enableJceSteps", connector.getJceEnabled() != false ? StepBuilder.getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put("muleConfForJceSteps", connector.getJceEnabled() != false ? StepBuilder.getUpdateMuleConfForJceEnabledJavaSteps().getXmlConfig() : "");
        valuesMap.put("PROPERTIES", connector.getParallelBuilds() != false ? "" : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put("buildWrappers", "");
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

    private String unzipMulesSteps(ConnectorConfiguration connector) {
        String steps = "";
        for (String muleVersion : this.muleVersionRetriever.getEEMuleList(connector.getMinMuleVersion())) {
            steps = steps.concat(StepBuilder.unzipMuleStandaloneStep(muleVersion).getXmlConfig());
        }
        if (!connector.getIsEnterprise().booleanValue()) {
            for (String muleVersion : this.muleVersionRetriever.getCEMuleList(connector.getMinMuleVersion())) {
                steps = steps.concat(StepBuilder.unzipMuleStandaloneStep(muleVersion).getXmlConfig());
            }
        }
        return steps;
    }

    private String ctfBuildSteps(ConnectorConfiguration connector, String branch) {
        String steps = new MavenStep(CLEAN_PACKAGE_DSKIP_TESTS_GOAL).getXmlConfig();
        for (String muleVersion : this.muleVersionRetriever.getEEMuleList(connector.getMinMuleVersion())) {
            steps = steps.concat(StepBuilder.ctfBuildStep(connector, muleVersion, branch).getXmlConfig());
        }
        if (!connector.getIsEnterprise().booleanValue()) {
            for (String muleVersion : this.muleVersionRetriever.getCEMuleList(connector.getMinMuleVersion())) {
                steps = steps.concat(StepBuilder.ctfBuildStep(connector, muleVersion, branch).getXmlConfig());
            }
        }
        return steps;
    }
}

