package org.mule.tools.connectivity.jenkins.client;

import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.publishers.Mailer;
import org.mule.tools.connectivity.jenkins.client.models.scm.GithubSCM;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;

import java.util.LinkedList;
import java.util.List;

// TODO REFACTOR --> HORRIBLE CODE
public class ConnectorConfiguration {

    private String category;
    private Boolean isEnterprise;
    private Boolean masterSupport;
    private Boolean developSupport;
    private Boolean multiMuleSupport;
    private Boolean developClassicSupport;
    private Boolean masterClassicSupport;
    private String minMuleVersion;
    private String name;
    private String gitHubUrl;
    private String credentialUrl;
    private String properties;
    private List<JenkinsModel> buildSteps;
    private String testingConfiguration;
    private String testingConfigurationForMaster;
    private GithubSCM githubConfig;
    private Mailer mailer;
    private String overrideMuleLocation;
    private String hackStep;
    private List<String> activeConfigs;
    private Boolean jceEnabled;
    private Boolean cloudHubEnabled;
    private Boolean parallelBuilds;
    private String jvmOptions;
    private String mule4Branch;

    /**
     * Default boolean values have no effect. They are overridden by the JsonUtils.getBoolean() method and set to true.
     */
    public ConnectorConfiguration(String name) {
        this.name = name;
        this.githubConfig = new GithubSCM();
        this.buildSteps = new LinkedList<>();
        this.mailer = new Mailer();
        this.setIsEnterprise(Boolean.FALSE);
        this.setMasterSupport(Boolean.FALSE);
        this.setDevelopSupport(Boolean.FALSE);
        this.setMultiMuleSupport(Boolean.FALSE);
        this.setMinMuleVersion("3.5.0");
        this.overrideMuleLocation = "";
        this.setJceEnabled(Boolean.FALSE);
        this.setCloudHubEnabled(Boolean.FALSE);
        this.setParallelBuilds(Boolean.FALSE);
    }

    public Boolean getParallelBuilds() {
        return parallelBuilds;
    }

    public void setParallelBuilds(Boolean parallelBuilds) {
        this.parallelBuilds = parallelBuilds;
    }

    public List<String> getActiveConfigs() {
        return activeConfigs;
    }

    public Boolean getCloudHubEnabled() {
        return cloudHubEnabled;
    }

    public void setCloudHubEnabled(Boolean cloudHubEnabled) {
        this.cloudHubEnabled = cloudHubEnabled;
    }

    public void setActiveConfigs(List<String> activeConfigs) {
        this.activeConfigs = activeConfigs;
    }

    public String getHackStep() {
        return hackStep;
    }

    public void setHackStep(String hackStep) {
        this.hackStep = hackStep;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getMinMuleVersion() {
        return minMuleVersion;
    }

    public void setMinMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public Boolean getDevelopClassicSupport() {
        return developClassicSupport;
    }

    public void setDevelopClassicSupport(Boolean developClassicSupport) {
        this.developClassicSupport = developClassicSupport;
    }

    public Boolean getMasterClassicSupport() {
        return masterClassicSupport;
    }

    public void setMasterClassicSupport(Boolean masterClassicSupport) {
        this.masterClassicSupport = masterClassicSupport;
    }

    public String getOverrideMuleLocation() {
        return overrideMuleLocation;
    }

    public void setOverrideMuleLocation(String overrideMuleLocation) {
        this.overrideMuleLocation = overrideMuleLocation;
    }

    public Boolean getDevelopSupport() {
        return developSupport;
    }

    public void setDevelopSupport(Boolean developSupport) {
        this.developSupport = developSupport;
    }

    public Boolean getMasterSupport() {
        return masterSupport;
    }

    public void setMasterSupport(Boolean masterSupport) {
        this.masterSupport = masterSupport;
    }

    public Boolean getMultiMuleSupport() {
        return multiMuleSupport;
    }

    public void setMultiMuleSupport(Boolean multiMuleSupport) {
        this.multiMuleSupport = multiMuleSupport;
    }

    public String getGitHubUrl() {
        return gitHubUrl;
    }

    public void setGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    public String getCredentialUrl() {
        return credentialUrl;
    }

    public void setCredentialUrl(String credentialUrl) {
        this.credentialUrl = credentialUrl;
    }

    public void setMailer(String emails) {
        mailer.setMails(emails);
    }

    public Mailer getMailer() {
        return mailer;
    }

    public Boolean getJceEnabled() {
        return jceEnabled;
    }

    public void setJceEnabled(Boolean jceEnabled) {
        this.jceEnabled = jceEnabled;
    }

    public Boolean getIsEnterprise() {
        return isEnterprise;
    }

    public void setIsEnterprise(Boolean isEnterprise) {
        this.isEnterprise = isEnterprise;
    }

    public List<JenkinsModel> getBuildSteps() {
        return buildSteps;
    }

    public String getTestingConfiguration() {
        return testingConfiguration;
    }

    public void setTestingConfiguration(String testingConfiguration) {
        this.testingConfiguration = testingConfiguration;
    }

    public String getTestingConfigurationForMaster() {
        return testingConfigurationForMaster;
    }

    public void setTestingConfigurationForMaster(String testingConfigurationForMaster) {
        this.testingConfigurationForMaster = testingConfigurationForMaster;
    }

    public void addShellStep(String step) {
        buildSteps.add(new ShellStep(step));
    }

    public void addShellStep(ShellStep step) {
        buildSteps.add(step);
    }

    public void addMavenStep(String step) {
        buildSteps.add(new MavenStep(step));
    }

    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getSteps() {
        return getCompleteSteps(buildSteps);
    }

    private String getCompleteSteps(List<JenkinsModel> steps) {
        String completeSteps = "";
        for (JenkinsModel step : steps) {
            completeSteps = completeSteps.concat(step.getXmlConfig()).concat("\n");
        }
        return completeSteps;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addGitHubConfig(String gitUrl) {
        gitHubUrl = gitUrl;
        githubConfig.setGitHubUrl(gitUrl);
    }

    //TODO se podria retornar un objeto totalmente nuevo con un factory o algo por el estilo
    public GithubSCM getGitHubConfig(String branch) {
        githubConfig.setGitHubBranch(branch);
        return githubConfig;
    }

    public String getJvmOptions() {
        return jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public String getMule4Branch() {
        return mule4Branch;
    }

    public void setMule4Branch(String mule4Branch) {
        this.mule4Branch = mule4Branch;
    }
}
