package org.mule.tools.connectivity.jenkins.client.models.buildwrappers;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class Bindings implements BuildWrapper {

    /**
     * @param bindings
     */
    public Bindings(final BuildWrapper... bindings) {
        this.bindings = ImmutableList.copyOf(bindings);
    }

    private ImmutableList<BuildWrapper> bindings;

    @Override
    public String getXmlConfig() {
        String bindingsXml = Joiner.on(" ").join(Iterables.transform(bindings, input -> input.getXmlConfig()));
        return "<org.jenkinsci.plugins.credentialsbinding.impl.SecretBuildWrapper plugin=\"credentials-binding@1.3\">"
                + "  <bindings>"
                + bindingsXml
                + "  </bindings>"
                + "</org.jenkinsci.plugins.credentialsbinding.impl.SecretBuildWrapper>"
                ;
    }

}
