package org.mule.tools.connectivity.jenkins.client.retrievers;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

import java.util.List;

public abstract class MuleVersionRetriever {

    public List<String> getEEMule3xList() {
        throw new UnsupportedOperationException();
    }

    public List<String> getEEMule3xList(String muleMinVersion) {
        throw new UnsupportedOperationException();
    }

    public List<String> getCEMule3xList(){
        throw new UnsupportedOperationException();
    }

    public List<String> getCEMule3xList(String muleMinVersion){
        throw new UnsupportedOperationException();
    }

    public List<String> getMule4xList() {
        throw new UnsupportedOperationException();
    }

    boolean is4xVersion(String muleVersion) {
        return muleVersion.contains("-4.");
    }

    boolean isValidMuleVersion(String minMuleVersion, String muleVersion) {
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion(minMuleVersion);
        DefaultArtifactVersion actualVersion = new DefaultArtifactVersion(muleVersion);
        return actualVersion.compareTo(minVersion) >= 0;
    }

}
