package org.mule.tools.connectivity.jenkins.client.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GithubSSHURLParser {

    private static final String SSH_URL_PATTERN_REGEX = "git@github.com:([\\w\\W]+)/([\\w\\W]+).git";
    private static final String HTTPS_URL_FORMAT = "https://github.com/%s/%s/";
    private static final Pattern SSH_URL_PATTERN = Pattern.compile(SSH_URL_PATTERN_REGEX);

    private String sshUrl;
    private String githubUser;
    private String githubRepository;

    public GithubSSHURLParser(String sshUrl) {
        this.sshUrl = sshUrl;
        final Matcher matcher = SSH_URL_PATTERN.matcher(sshUrl);
        if (!matcher.find()) {
            throw new RuntimeException(String.format("The given SSH URL [%s] is invalid", sshUrl));
        }
        githubUser = matcher.group(1);
        githubRepository = matcher.group(2);
    }

    public String getGithubUser() {
        return githubUser;
    }

    public String getGithubRepository() {
        return githubRepository;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public String getHttpsUrl() {
        return String.format(HTTPS_URL_FORMAT, this.getGithubUser(), this.getGithubRepository());
    }

    public static String toHttpsURL(final String sshUrl) {
        return new GithubSSHURLParser(sshUrl).getHttpsUrl();
    }
}
