/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.Bindings;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.UsernamePasswordMultiBinding;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.triggers.PushGitHubTrigger;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class DevelopClassicXmlConfigBuilder
extends BasicXmlConfigBuilder {
    public static String buildXmlConfig(ConnectorConfiguration connector, String mavenGoal) {
        String xml = DevelopClassicXmlConfigBuilder.getResourceAsString("basic-template.xml");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("githubConfig", connector.getGitHubConfig("develop").getXmlConfig());
        valuesMap.put("GITHUB_HTTP_URL", GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put("unzipMuleShellStep", "");
        valuesMap.put("connectorSteps", connector.getSteps());
        valuesMap.put("ctfBuildStep", StepBuilder.cleanStep().getXmlConfig() + DevelopClassicXmlConfigBuilder.getDevelopBuildSteps(connector, mavenGoal) + StepBuilder.deployStep().getXmlConfig() + StepBuilder.sonarStep().getXmlConfig() + StepBuilder.newSonarStep().getXmlConfig());
        valuesMap.put("mailer", connector.getMailer().getXmlConfig());
        valuesMap.put("trigger", new TimeTrigger("@midnight").getXmlConfig() + new PushGitHubTrigger().getXmlConfig());
        valuesMap.put("jdkVersion", connector.getJceEnabled() != false ? "Oracle JDK 1.8 JCE" : "Oracle JDK 8");
        valuesMap.put("enableJceSteps", connector.getJceEnabled() != false ? StepBuilder.getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put("muleConfForJceSteps", "");
        valuesMap.put("PROPERTIES", connector.getParallelBuilds() != false ? "" : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put("buildWrappers", new Bindings(new UsernamePasswordMultiBinding("7709cb6e-a949-4033-950f-cd1bb38b3b65", "SONAR_USERNAME", "SONAR_PASSWORD")).getXmlConfig());
        return new StrSubstitutor(valuesMap).replace(xml);
    }

    private static String getDevelopBuildSteps(ConnectorConfiguration connector, String mavenGoal) {
        ArrayList<String> stepList = new ArrayList<String>();
        if (!connector.getActiveConfigs().isEmpty()) {
            connector.getActiveConfigs().stream().forEach(config -> stepList.add(StepBuilder.classicDevelopBuildStep(connector, mavenGoal, config).getXmlConfig()));
        } else {
            stepList.add(StepBuilder.classicDevelopBuildStep(connector, mavenGoal).getXmlConfig());
        }
        return stepList.stream().reduce("", String::concat);
    }
}

