package org.mule.tools.connectivity.jenkins.client.models.scm;

import org.apache.commons.lang.StringUtils;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;

/**
 * Created by estebanwasinger on 6/25/15.
 */
public class GithubSCM implements JenkinsModel {

    public String getGitHubUrl() {
        return gitHubUrl;
    }

    public void setGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    public String getGitHubBranch() {
        return gitHubBranch;
    }

    public void setGitHubBranch(String gitHubBranch) {
        this.gitHubBranch = gitHubBranch;
    }

    private String gitHubUrl;
    private String gitHubBranch;
    private String credentialsId;

    public GithubSCM(){};

    public GithubSCM(String gitHubUrl, String gitHubBranch){
        this.gitHubUrl = gitHubUrl;
        this.gitHubBranch = gitHubBranch;
    }
    public GithubSCM(String gitHubUrl, String gitHubBranch, String credentialsId){
        this.gitHubUrl = gitHubUrl;
        this.gitHubBranch = gitHubBranch;
        this.credentialsId = credentialsId;
    }

    private String getCredentials() {
        if (StringUtils.isNotEmpty(credentialsId)) {
            return "        <credentialsId>" + credentialsId + "</credentialsId>";
        } else {
            return "";
        }
    }

    @Override
    public String getXmlConfig() {
        return "<scm class=\"hudson.plugins.git.GitSCM\" plugin=\"git@2.3.5\">\n" +
                "    <configVersion>2</configVersion>\n" +
                "    <userRemoteConfigs>\n" +
                "      <hudson.plugins.git.UserRemoteConfig>\n" +
                "        <url>"+gitHubUrl+"</url>\n" +
                getCredentials() +
                "      </hudson.plugins.git.UserRemoteConfig>\n" +
                "    </userRemoteConfigs>\n" +
                "    <branches>\n" +
                "      <hudson.plugins.git.BranchSpec>\n" +
                "        <name>"+gitHubBranch+"</name>\n" +
                "      </hudson.plugins.git.BranchSpec>\n" +
                "    </branches>\n" +
                "    <doGenerateSubmoduleConfigurations>false</doGenerateSubmoduleConfigurations>\n" +
                "    <submoduleCfg class=\"list\"/>\n" +
                "    <extensions/>\n" +
                "  </scm>";
    }
}
