package org.mule.tools.connectivity.jenkins.client.util;

import com.google.common.base.Splitter;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StringUtils {

    public static final String ESCAPED_NEWLINE = "\\\n";

    /* Inserts a escaped newline every MAX_CHAR_LENGTH in a String,
       useful for avoid generating wide texts. */
    public static String reduceWithNewlines(String text, int size) {
        return StreamSupport.stream(Splitter.fixedLength(size).split(text).spliterator(), false).collect(Collectors.joining(ESCAPED_NEWLINE));
    }

    /* Removes the escaped newlines from a String. */
    public static String removeNewlines(String text) {
        return text.replace(ESCAPED_NEWLINE, "");
    }

}
