package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.Bindings;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.UsernamePasswordMultiBinding;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.step.EnvironmentVariableInjectStep;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.PushGitHubTrigger;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.joining;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.BATCH_MODE;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.JACOCO_PREPARE_PHASE;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.MAVEN_REPO_SETTINGS;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.cleanStep;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.getEnableJceSteps;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.packageWithoutTestsStep;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.unzipMuleStandaloneStep;

public class Mule4XmlConfigBuilder extends BasicXmlConfigBuilder {

    private static final String COPY_EXTENSION_TO_ROOT_SHELL_CMD = "EXTENSION=$(find target -name \"*.zip\" ! -name \"*studio-plugin*\" -maxdepth 1 -exec basename {} \\;)\ncp target/$EXTENSION .\necho \"extension_filename=$WORKSPACE/$EXTENSION\" > mvn_run.properties";
    private static final String PROPERTIES_FILE_PATH = "$WORKSPACE/mvn_run.properties";
    private static final String MULE3_TEST_AGAINST_4_MVN_SETTINGS = " -Ddeploylogs=true -Ddeploymentprofile=local -Dmuledirectory=${WORKSPACE}/mule-standalone-4.0.0-M3 -Dextensionfile=${extension_filename} -Dconnector.testing.version=\"2.0.0-SNAPSHOT\"";
    private static final String CHECKOUT_DEVELOP_CMD = "git checkout " + DEVELOP_BRANCH;


    public static String buildXmlConfig(final MuleVersionRetriever muleVersionRetriever, final ConnectorConfiguration connector) {
        List<String> mule4xList = muleVersionRetriever.getMule4xList();
        String xml = getResourceAsString(BASIC_TEMPLATE_XML);

        Map<String, String> valuesMap = new HashMap<>();
        valuesMap.put(GITHUB_CONFIG, connector.getGitHubConfig(connector.getMule4Branch()).getXmlConfig());
        valuesMap.put(GITHUB_HTTP_URL, GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put(UNZIP_MULE_SHELL_STEP, getUnzipMulesStep(mule4xList));
        valuesMap.put(CONNECTOR_STEPS, "");
        valuesMap.put(CTF_BUILD_STEP, packageWithoutTestsStep().getXmlConfig() +
                                      new ShellStep(COPY_EXTENSION_TO_ROOT_SHELL_CMD).getXmlConfig() +
                                      new EnvironmentVariableInjectStep(PROPERTIES_FILE_PATH).getXmlConfig() +
                                      new ShellStep(CHECKOUT_DEVELOP_CMD).getXmlConfig() +
                                      connector.getSteps() +
                                      cleanStep().getXmlConfig() +
                                      getDevelopBuildSteps(connector));
        valuesMap.put(MAILER, connector.getMailer().getXmlConfig());
        valuesMap.put(TRIGGER, new TimeTrigger(MIDNIGHT).getXmlConfig() + new PushGitHubTrigger().getXmlConfig());
        valuesMap.put(JDK_VERSION, connector.getJceEnabled() ? JDK_8_JCE : JDK_8);
        valuesMap.put(ENABLE_JCE_STEPS, connector.getJceEnabled() ? getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put(MULE_CONF_FOR_JCE_STEPS, "");
        valuesMap.put(PROPERTIES, connector.getParallelBuilds() ? StringUtils.EMPTY : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put(BUILD_WRAPPERS, new Bindings(new UsernamePasswordMultiBinding("7709cb6e-a949-4033-950f-cd1bb38b3b65", "SONAR_USERNAME", "SONAR_PASSWORD")).getXmlConfig());
        return new StrSubstitutor(valuesMap).replace(xml);
    }

    private static String getUnzipMulesStep(List<String> mule4xList) {
        List<ShellStep> steps = new ArrayList<ShellStep>();
        mule4xList.forEach(m4Version -> steps.add(unzipMuleStandaloneStep(m4Version)));
        return steps.stream().map(ShellStep::getXmlConfig).collect(joining());
    }

    private static String getDevelopBuildSteps(final ConnectorConfiguration connector) {
        List<String> stepList = new ArrayList<String>();

        if (!connector.getActiveConfigs().isEmpty()) {
            connector.getActiveConfigs().forEach(config -> stepList.add(classicDevelopBuildStepWithTestsAgainstMule4(connector, connector.getTestingConfiguration(), config).getXmlConfig()));
        } else {
            stepList.add(classicDevelopBuildStepWithTestsAgainstMule4(connector, connector.getTestingConfiguration()).getXmlConfig());
        }

        return stepList.stream().collect(joining());
    }

    private static MavenStep classicDevelopBuildStepWithTestsAgainstMule4(final ConnectorConfiguration connector, final String mavenGoal, final String activeConfig) {
        return new MavenStep(BATCH_MODE + JACOCO_PREPARE_PHASE + " " + mavenGoal + " -Dactiveconfiguration=" + activeConfig + " " + connector.getTestingConfiguration() + StepBuilder.MAVEN_REPO_SETTINGS + MULE3_TEST_AGAINST_4_MVN_SETTINGS, connector.getJvmOptions());
    }

    private static MavenStep classicDevelopBuildStepWithTestsAgainstMule4(final ConnectorConfiguration connector, final String mavenGoal) {
        return new MavenStep(BATCH_MODE + JACOCO_PREPARE_PHASE + " " + mavenGoal + MAVEN_REPO_SETTINGS + MULE3_TEST_AGAINST_4_MVN_SETTINGS, connector.getJvmOptions());
    }

}
