/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.lang.StringEscapeUtils;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;

public class MavenStep
implements JenkinsStep {
    private String mavenGoal;
    private String jvmOptions;

    public String getMavenGoal() {
        return this.mavenGoal;
    }

    public void setMavenGoal(String mavenGoal) {
        this.mavenGoal = mavenGoal;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public MavenStep(String mavenGoal, String jvmOptions) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
    }

    public MavenStep(String mavenGoal) {
        this.mavenGoal = StringEscapeUtils.escapeXml((String)mavenGoal);
    }

    private String getJvmOptionsXml() {
        if (this.jvmOptions != null) {
            return "<jvmOptions>" + StringEscapeUtils.escapeXml((String)this.jvmOptions) + "</jvmOptions>\n";
        }
        return "";
    }

    @Override
    public String getXmlConfig() {
        return "    <hudson.tasks.Maven>\n      <targets>" + StringEscapeUtils.escapeXml((String)this.mavenGoal) + "</targets>\n      <mavenName>(Default)</mavenName>\n" + this.getJvmOptionsXml() + "      <usePrivateRepository>false</usePrivateRepository>\n    </hudson.tasks.Maven>";
    }
}

