package org.mule.tools.connectivity.jenkins.client.retrievers;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class WebDavMuleVersionsRetriever extends MuleVersionRetriever {

    private String user;
    private String password;
    private static List<String> muleList;
    private static WebDavMuleVersionsRetriever instance = null;

    private Logger logger = LogManager.getLogger(WebDavMuleVersionsRetriever.class);
    private String webdavUrl = "https://repository-mule-connectors.forge.cloudbees.com/private/mules/";


    public static WebDavMuleVersionsRetriever getInstance(String user, String password) {
        if (instance == null) {
            instance = new WebDavMuleVersionsRetriever(user, password);
        }

        return instance;
    }

    public WebDavMuleVersionsRetriever(String user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public List<String> getEEMule3xList(String muleMinVersion) {
        return getEEMule3xList().stream()
                .filter(mule -> isValidMuleVersion(muleMinVersion, mule.split("-")[3]))
                .collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMule3xList() {
        return getMuleList().stream()
                .filter(mule -> !is4xVersion(mule))
                .filter(mule -> !mule.toLowerCase().contains("enterprise"))
                .sorted()
                .collect(Collectors.toList());
    }

    @Override
    public List<String> getEEMule3xList() {
        return getMuleList().stream()
                .filter(mule -> !is4xVersion(mule))
                .filter(mule -> mule.toLowerCase().contains("enterprise"))
                .sorted()
                .collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMule3xList(String muleMinVersion) {
        return getCEMule3xList().stream()
                .filter(mule -> isValidMuleVersion(muleMinVersion, mule.split("-")[2]))
                .collect(Collectors.toList());
    }

    @Override
    public List<String> getMule4xList() {
        return getMuleList().stream()
                .filter(mule -> is4xVersion(mule))
                .sorted()
                .collect(Collectors.toList());
    }

    private List<String> getMuleList() {
        if (muleList != null) {
            logger.trace("Using already retrieved Mule runtime list.");
            return muleList;
        }

        List<DavResource> resources;
        try {
            Sardine sardine = SardineFactory.begin(user, password);
            resources = sardine.getResources(webdavUrl);
            sardine.shutdown();
        } catch (IOException e) {
            throw new RuntimeException("Problem retrieving mule versions. Please check your credentials and ensure that are correct.");
        }

        muleList = resources.stream()
                .filter(res -> res.getName().endsWith(".zip") && !res.getName().startsWith("._"))
                .map(res -> res.getName().substring(0, res.getName().length() - 4))
                .collect(Collectors.toList());

        return muleList;
    }

    public String getWebdavUrl() {
        return webdavUrl;
    }

    public void setWebdavUrl(String webdavUrl) {
        this.webdavUrl = webdavUrl;
    }

}
