package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.Mailer;
import org.mule.tools.connectivity.jenkins.client.models.scm.GithubSCM;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;

/**
 * Created by estebanwasinger on 11/26/15.
 */
public class DummyXmlConfigBuilder extends BasicXmlConfigBuilder{

    String xml = getResourceAsString(BASIC_TEMPLATE_XML);

    public void buildXmlConfig(ConnectorConfiguration connector) {
    JenkinsConfigBuilder.getJobXml(new GithubSCM("https://github.com/estebanwasinger/slack-connector","develop"))
            .withStep(new MavenStep("clean install"))
            .withTrigger(new TimeTrigger("* * * * *"))
            .withProperty(new JobBlocker(""))
            .withPublisher(new Mailer("esteban.wasinger@mulesoft.com"))
            .build();
    }
}
