package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.classicMasterBuildStep;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.getEnableJceSteps;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JunitResultArchiver;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;

import static org.mule.tools.connectivity.jenkins.client.JobConstants.*;


public class MasterClassicXmlConfigBuilder extends BasicXmlConfigBuilder{

    public static String buildXmlConfig(final ConnectorConfiguration connector, final String mavenGoal){

        String xml = getResourceAsString(BASIC_TEMPLATE_XML);

        Map<String, String> valuesMap = new HashMap<>();
        valuesMap.put(GITHUB_CONFIG, connector.getGitHubConfig(MASTER_BRANCH).getXmlConfig());
        valuesMap.put(GITHUB_HTTP_URL, GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put(UNZIP_MULE_SHELL_STEP, "");
        valuesMap.put(CONNECTOR_STEPS, connector.getSteps());
        valuesMap.put(CTF_BUILD_STEP, classicMasterBuildStep(connector, mavenGoal).getXmlConfig());
        valuesMap.put(MAILER, connector.getMailer().getXmlConfig());
        valuesMap.put(TRIGGERS, new TimeTrigger(EVERY_15_DAYS).getXmlConfig());
        valuesMap.put(JDK_VERSION, connector.getJceEnabled() ? JDK_1_7_JCE : JDK_1_7);
        valuesMap.put(ENABLE_JCE_STEPS, connector.getJceEnabled() ? getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put(MULE_CONF_FOR_JCE_STEPS, "");
        valuesMap.put(PROPERTIES, connector.getParallelBuilds() ? StringUtils.EMPTY : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put(BUILD_WRAPPERS, "");
        valuesMap.put(PUBLISHERS, new JunitResultArchiver().getXmlConfig());
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

}
