/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.util;

import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;

public class StepBuilder {
    public static final String BATCH_MODE = " -B";
    public static final String JACOCO_PREPARE_PHASE = " org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent";
    public static final String SONAR_PHASE = " org.codehaus.mojo:sonar-maven-plugin:2.6:sonar";
    public static final String MAVEN_REPO_SETTINGS = " -Dmavenlocalrepo=/home/jenkins/.m2 -Dm2home=/opt/maven/latest";

    public static MavenStep classicDevelopBuildStep(String mavenGoal) {
        return new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + MAVEN_REPO_SETTINGS);
    }

    public static MavenStep classicDevelopBuildStep(ConnectorConfiguration connector, String mavenGoal) {
        return new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + " " + connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
    }

    public static MavenStep classicDevelopBuildStep(ConnectorConfiguration connector, String mavenGoal, String activeConfig) {
        return new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + " -Dactiveconfiguration=" + activeConfig + " " + connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
    }

    public static MavenStep classicMasterBuildStep(ConnectorConfiguration connector, String mavenGoal) {
        return new MavenStep(" -B clean " + mavenGoal + " " + (String)Objects.firstNonNull((Object)connector.getTestingConfigurationForMaster(), (Object)connector.getTestingConfiguration()) + " -Dmule.testingMode=true" + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
    }

    public static MavenStep sonarStep() {
        return new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dappend=true");
    }

    public static MavenStep newSonarStep() {
        return new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dappend=true -Dsonar.host.url=https://sonar-tools.mulesoft.com/ -Dsonar.login=$SONAR_USERNAME -Dsonar.password=$SONAR_PASSWORD");
    }

    public static MavenStep newSonarPRBuilderStep(ConnectorConfiguration connector) {
        GithubSSHURLParser githubSSHURLParser = new GithubSSHURLParser(connector.getGitHubUrl());
        String repoUrl = githubSSHURLParser.getGithubUser() + "/" + githubSSHURLParser.getGithubRepository();
        return new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dsonar.host.url=https://sonar-tools.mulesoft.com/ -Dsonar.login=$SONAR_USERNAME -Dsonar.password=$SONAR_PASSWORD -Dsonar.analysis.mode=preview -Dsonar.github.oauth=$SONAR_GITHUB_OAUTH -Dsonar.github.pullRequest=$ghprbPullId -Dsonar.github.repository=" + repoUrl);
    }

    public static MavenStep deployStep() {
        return new MavenStep(" -B deploy -DskipTests");
    }

    public static MavenStep cleanStep() {
        return new MavenStep(" -B clean");
    }

    public static MavenStep packageWithoutTestsStep() {
        return new MavenStep(" -B clean package -Dmaven.test.skip");
    }

    public static MavenStep ctfBuildStep(ConnectorConfiguration connector, String muleVersion, String branch) {
        return StepBuilder.ctfBuildStep(connector, muleVersion, branch, null);
    }

    public static MavenStep ctfBuildStep(ConnectorConfiguration connector, String muleVersion, String branch, String activeConfig) {
        String testingConfig = (String)Objects.firstNonNull((Object)("master".equals(branch) ? connector.getTestingConfigurationForMaster() : null), (Object)connector.getTestingConfiguration());
        String activeConfigParameter = StringUtils.isBlank((CharSequence)activeConfig) ? "" : " -Dactiveconfiguration=" + activeConfig;
        return new MavenStep("test " + testingConfig + activeConfigParameter + MAVEN_REPO_SETTINGS + " -Ddeploymentprofile=local -Dmuledirectory=" + connector.getOverrideMuleLocation() + muleVersion + " -Dsurefire.reportNameSuffix=" + muleVersion, connector.getJvmOptions());
    }

    public static MavenStep cloudHubBuildStep(ConnectorConfiguration connector) {
        return new MavenStep("test " + connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS + " -Ddeploymentprofile=cloudhub -Dcloudhubuser=${cloudhubuser} -Dcloudhubpassword=${cloudhubpassword} -Dsurefire.reportNameSuffix=cloudhub", connector.getJvmOptions());
    }

    public static ShellStep getEnableJceSteps() {
        return new ShellStep("if [ \\! -d $HOME/jdk6jce ]\nthen\n  cp -Lr /opt/jdk/jdk1.6.latest/ $HOME/jdk6jce\nfi\ncp -f /private/**/jce/jce6/*.jar $HOME/jdk6jce/jre/lib/security\n\nif [ \\! -d $HOME/jdk7jce ]\nthen\n  cp -Lr /opt/jdk/jdk1.7.latest/ $HOME/jdk7jce\nfi\ncp -f /private/**/jce/jce7/*.jar $HOME/jdk7jce/jre/lib/security\n\nif [ \\! -d $HOME/jdk8jce ]\nthen\n  cp -Lr /opt/jdk/jdk8.latest/ $HOME/jdk8jce\nfi\ncp -f /private/**/jce/jce8/*.jar $HOME/jdk8jce/jre/lib/security\n\n");
    }

    public static ShellStep unzipMuleStandaloneStep(String muleVersion) {
        return new ShellStep("if [ \\! -d " + muleVersion + " ]\nthen\nunzip /private/mule-connectors/mules/" + muleVersion + ".zip\nfi\n");
    }

    public static ShellStep getUpdateMuleConfForJceEnabledJavaSteps() {
        return new ShellStep("sed -i.bak s?wrapper.java.command=/opt/jdk/jdk1.6.latest/bin/java?wrapper.java.command=$HOME/jdk6jce/jre/bin/java?g **/conf/wrapper.conf\nsed -i.bak s?wrapper.java.command=/opt/jdk/jdk1.7.latest/bin/java?wrapper.java.command=$HOME/jdk7jce/jre/bin/java?g **/conf/wrapper.conf\nsed -i.bak s?wrapper.java.command=/opt/jdk/jdk8.latest/bin/java?wrapper.java.command=$HOME/jdk8jce/jre/bin/java?g **/conf/wrapper.conf\n");
    }

    public static String stepsToString(JenkinsModel ... steps) {
        String stringSteps = "";
        for (JenkinsModel step : steps) {
            stringSteps = stringSteps.concat(step.getXmlConfig());
        }
        return stringSteps;
    }
}

